/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.phone;

import com.smile.telephony.CTIPort;
import com.smile.telephony.CallInfo;
import com.smile.telephony.DeviceListener;
import com.smile.telephony.Port;
import com.smile.telephony.PortEventListener;
import com.smile.telephony.ResourceManager;
import com.smile.telephony.sip.SipDevice;
import com.smile.telephony.sip.SipPort;
import java.io.File;
import java.io.OutputStream;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import smile.cti.client.PbxServiceManager;
import smile.cti.client.ServiceManager;
import smile.cti.phone.Line;
import smile.cti.phone.Lines;
import smile.cti.phone.PhoneDevice;
import smile.cti.phone.PhoneLine;
import smile.util.ConnectionInfo;
import smile.util.MimeMessage;
import smile.util.ResourceStore;

public class PhoneManager
implements DeviceListener {
    private ServiceManager service;
    private ResourceManager manager;
    private PhoneDevice device;
    private Lines lines;
    private CTIPort conferenceChannel;
    private Line conferenceLine;
    private ConnectionInfo connectionInfo;
    private String trunkid;
    private String userid;
    private boolean running;
    private boolean selfcall;
    private boolean callWaiting;
    private boolean connecting;
    private boolean reconnecting;
    private boolean localConferenceMode;
    private int autoanswerMode;
    private boolean pushcall;
    private Vector iplines;
    private Vector phoneLines;
    private HashMap trunks = new HashMap();
    private HashSet registrations = new HashSet();
    private long lastConnectTrial;
    public static final String CC_LAYOUT_TYPE = "<layout_type>";
    public static final String CC_LAYOUT_MODE = "<layout_mode>";
    public static final String CC_ROOT_VIEW = "<root_view>";
    public static final String CC_GET_ACTIONS = "<get_actions>";
    public static final String CC_SELECT_ACTION = "<select_action>";
    public static final String CC_SELECT_ROOT = "<select_root>";
    public static final String CC_RETURN_VALUE = "<return_value>";
    public static final String CC_BITRATE = "<bitrate>";

    public PhoneManager(ServiceManager service) throws Exception {
        CTIPort channel;
        int i;
        this.service = service;
        this.localConferenceMode = service.getLocalConferenceMode();
        this.manager = new ResourceManager(service.getClass().getName());
        CTIPort[] ports = (CTIPort[])this.manager.getPortDrivers();
        if (ports == null) {
            throw new Exception("Channels not available");
        }
        this.iplines = new Vector();
        this.phoneLines = new Vector();
        for (int i2 = 0; i2 < ports.length; ++i2) {
            Port port = ports[i2].getPort();
            if (port instanceof SipPort) {
                this.iplines.addElement(ports[i2]);
                continue;
            }
            if (!(port instanceof PhoneLine)) continue;
            this.device = ((PhoneLine)port).getDevice();
            this.phoneLines.addElement(ports[i2]);
        }
        this.lines = new Lines(this.device);
        Vector chans = this.device.getLineChannels();
        for (i = 0; i < chans.size(); ++i) {
            PhoneLine phoneLine = (PhoneLine)chans.elementAt(i);
            phoneLine.setConferenceMode(this.localConferenceMode);
            String lineName = phoneLine.getName();
            Line line = new Line(lineName, service.createLinePane(lineName, this.device));
            this.lines.addLine(line);
        }
        for (i = 0; i < this.phoneLines.size(); ++i) {
            channel = (CTIPort)this.phoneLines.elementAt(i);
            channel.setPortEventListener(new PhoneListener(channel));
        }
        for (i = 0; i < this.iplines.size(); ++i) {
            channel = (CTIPort)this.iplines.elementAt(i);
            channel.setPortEventListener(new IPListener(channel));
        }
        SipDevice.setDeviceListener(this);
    }

    public void closeAudioLines() {
        this.device.closeAudioLines();
    }

    public void resetAudioLines() throws Exception {
        this.device.resetAudioLines();
    }

    public PhoneDevice getDevice() {
        return this.device;
    }

    public Lines getLines() {
        return this.lines;
    }

    public void setAutoconnect(String lineName) {
        Line line = this.lines.getLine(lineName);
        if (line != null) {
            line.setAutoconnect();
        }
    }

    public void clearLines() {
        this.lines.clearLines();
    }

    public void register(ConnectionInfo connectionInfo) throws Exception {
        this.connectionInfo = connectionInfo;
        this.register();
    }

    public void register() throws Exception {
        try {
            this.connecting = true;
            this.lastConnectTrial = System.currentTimeMillis();
            this.trunkid = SipDevice.doRegistration(this.connectionInfo.getParameters(), true);
            this.userid = SipDevice.getRegisteredUsername();
            if (this.userid == null) {
                throw new Exception("userid is null");
            }
            this.running = true;
            this.reconnecting = false;
            this.connecting = false;
            this.service.userRegistered(SipDevice.getRemoteSecret());
        }
        catch (Throwable e) {
            this.connecting = false;
            throw e;
        }
        this.toLog("REGISTER userid=" + this.userid);
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public void setRegistrationPassword(String pass) {
        SipDevice.setRegistrationPassword(pass);
        this.connectionInfo.setPassword(pass);
    }

    public void unregister(boolean unreg) {
        this.running = false;
        this.connecting = false;
        SipDevice.cancelRegistration(unreg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() {
        if (!this.reconnecting) {
            SipDevice.cancelRegistration(false);
        } else {
            PhoneManager phoneManager = this;
            synchronized (phoneManager) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        long diff = System.currentTimeMillis() - this.lastConnectTrial;
        this.toLog("isConnecting: connecting=" + this.connecting + " reconnecting=" + this.reconnecting + " diff=" + diff);
        if (this.connecting) {
            return diff < 60000L;
        }
        if (this.reconnecting) {
            PhoneManager phoneManager = this;
            synchronized (phoneManager) {
                this.notify();
            }
            return true;
        }
        return false;
    }

    public boolean isReconnecting() {
        this.toLog("isReconnecting=" + this.reconnecting);
        return this.reconnecting;
    }

    public boolean tryReconnect() {
        this.running = true;
        return this.tryReconnect(500L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryReconnect(long delay) {
        this.toLog("tryReconnect running=" + this.running + " reconnecting=" + this.reconnecting);
        if (this.reconnecting || !this.running) {
            return false;
        }
        this.reconnecting = true;
        PhoneManager phoneManager = this;
        synchronized (phoneManager) {
            try {
                this.wait(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        int sleeptime = 3000;
        while (this.running && this.reconnecting) {
            try {
                this.register();
                break;
            }
            catch (Exception e) {
                this.toLog("tryReconnect " + e + " sleeptime=" + sleeptime);
                String err = e.getMessage();
                if ("Forbidden".equals(err)) {
                    if (this.service instanceof PbxServiceManager) {
                        this.service.onError(err);
                    } else {
                        this.service.onExit(true, false);
                    }
                    this.reconnecting = false;
                    return false;
                }
                if (e instanceof ConcurrentModificationException) {
                    this.service.toLog(e);
                }
                this.service.stateChanged(0);
                PhoneManager phoneManager2 = this;
                synchronized (phoneManager2) {
                    try {
                        this.wait(sleeptime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        this.reconnecting = false;
        return true;
    }

    @Override
    public boolean onRegistrationLost(String rkey) {
        if (rkey == null) {
            this.service.setExited();
            return true;
        }
        if (!this.registrations.remove(rkey)) {
            return false;
        }
        String key = rkey.substring(0, rkey.indexOf(47));
        ConnectionInfo connectionInfo = (ConnectionInfo)this.trunks.get(key);
        this.toLog("onRegistrationLost key=" + key + " running=" + this.running + " trunk=" + connectionInfo + " trunkid=" + this.trunkid);
        if (connectionInfo != null) {
            connectionInfo.setState(false);
            return true;
        }
        if (!key.equals(this.trunkid)) {
            return false;
        }
        this.connectionLost();
        if (this.running && !this.connecting && !this.service.isOffline()) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    PhoneManager.this.tryReconnect(3000L);
                }
            };
            t.start();
        }
        return this.running;
    }

    public void connectionLost() {
        this.service.connectionLost();
    }

    @Override
    public void onRegistrationFound(String rkey) {
        this.registrations.add(rkey);
        String key = rkey.substring(0, rkey.indexOf(47));
        ConnectionInfo connectionInfo = (ConnectionInfo)this.trunks.get(key);
        this.toLog("onRegistrationFound key=" + key + " trunk=" + connectionInfo + " trunkid=" + this.trunkid);
        if (connectionInfo != null) {
            connectionInfo.setState(true);
            return;
        }
        this.userid = SipDevice.getRegisteredUsername();
        Thread t = new Thread(){

            @Override
            public void run() {
                PhoneManager.this.service.connectionSet();
            }
        };
        t.start();
    }

    public long getLastRegistrationTime() {
        return SipDevice.getLastRegistrationTime();
    }

    public String getUserId() {
        return this.userid;
    }

    public void setStun(String srvaddr) {
        SipDevice.setStun(this.trunkid, srvaddr);
    }

    public void setTrunk(ConnectionInfo connectionInfo, boolean sync) throws Exception {
        if (connectionInfo.isEnabled()) {
            String key = SipDevice.doRegistration(connectionInfo.getParameters(), sync);
            this.trunks.put(key, connectionInfo);
            if (sync) {
                connectionInfo.setState(true);
            }
        } else {
            SipDevice.cancelRegistration(connectionInfo.getParameters());
        }
    }

    public void removeTrunk(ConnectionInfo connectionInfo) throws Exception {
        SipDevice.cancelRegistration(connectionInfo.getParameters());
        connectionInfo.setState(false);
        for (Object key : this.trunks.keySet()) {
            if (connectionInfo != this.trunks.get(key)) continue;
            this.trunks.remove(key);
        }
    }

    public HashMap getTrunks() {
        return this.trunks;
    }

    public String sendMessage(String dest, String orig, Object content, int contentLength, String type, String subtype) throws Exception {
        return SipDevice.sendMessage(null, dest, orig, content, contentLength, type, subtype);
    }

    @Override
    public void incomingCallPresent() {
        this.manager.notifyWaitingPorts();
    }

    @Override
    public void incomingCallLost(CallInfo call_info) {
    }

    public Line getLine() {
        return this.lines.getLine();
    }

    public Line findLine(String party) {
        return this.lines.findLine(party);
    }

    private void lineStateChanged(int state, String number, String description, String lineName) {
        this.lineStateChanged(state, number, description, this.lines.getLine(lineName));
    }

    public void lineStateChanged(int state, String number, String description, Line line) {
        int oldstate = line.getState();
        this.toLog("lineStateChanged: " + line + " state=" + state + " d=" + description + " oldstate=" + oldstate);
        if (state == 3) {
            if (oldstate == 5) {
                this.device.setLocalPicture(true);
            }
        } else if (state == 9) {
            this.device.setLocalPicture(true);
        } else if (state == 5) {
            this.device.setLocalPicture(false);
        } else if (state == 8) {
            this.device.setLocalPicture(true);
            this.lines.clearLine(line, false);
        } else if (state == 0) {
            this.lines.clearLine(line, false);
        } else if (state == 10 && line.isPark()) {
            this.lines.dropCall(line.getName());
        }
        if (oldstate == 2 && this.callWaiting) {
            this.callWaiting = false;
        }
        line.lineStateChanged(state, description);
        this.service.lineStateChanged(state, number, description, line);
    }

    public Line setIncomingCall(String calledNumber, String callingNumber, Map props) {
        return this.lines.setIncomingCall(calledNumber, callingNumber, props);
    }

    public void setOutgoingCall(String lineName, String connectedNumber, Map props) {
        this.lines.setOutgoingCall(lineName, connectedNumber, props);
    }

    public void setCapabilities(int bandwidth) throws Exception {
        int[] caps;
        String os = System.getProperty("os.name");
        boolean hasg723 = os != null && os.toLowerCase().indexOf("windows") != -1;
        switch (bandwidth) {
            case 2: {
                if (hasg723) {
                    caps = new int[]{28166, 258, 3076, 25088};
                    break;
                }
                caps = new int[]{28166, 3076, 25088};
                break;
            }
            case 1: {
                if (hasg723) {
                    caps = new int[]{28164, 1284, 2308, 257, 3076, 25088};
                    break;
                }
                caps = new int[]{28164, 1284, 2308, 3076, 25088};
                break;
            }
            default: {
                caps = new int[]{28162, 1282, 2306, 25088};
            }
        }
        SipDevice.setCapabilities(caps);
    }

    public void setJitterBuffer(int value) {
        SipDevice.setJitterBuffer(value, 960);
    }

    public void setEndpointProperty(String key, Object value) {
        SipDevice.setProperty(key, value);
    }

    public void makeCall(String number, boolean video) {
        this.device.setVideoMode(video ? 0 : -1);
        Line line = this.lines.makeCall(number);
        this.toLog("makeCall " + number + " line=" + line);
        if (line == null) {
            return;
        }
        line.setVideo(video);
        this.incomingCallPresent();
    }

    public void makeCall(String number, Line line) {
        this.lines.makeCall(number, line);
        this.incomingCallPresent();
    }

    public void answerCall(String lineName, boolean video) {
        Line line;
        if (video) {
            this.device.setVideoMode(0);
        } else if (lineName != null) {
            line = this.lines.getLine(lineName);
            this.device.setVideoMode(line.isVideo() ? 2 : -1);
        }
        if (lineName != null) {
            this.lines.answerCall(lineName);
        } else {
            line = this.lines.getRingingLine();
            if (line != null) {
                line.setAutoconnect();
            }
        }
    }

    public void forwardCall(String lineName, String number) {
        this.lines.forwardCall(lineName, number);
    }

    public void rejectCall(String name) {
        this.lines.rejectCall(name);
    }

    public void dropCall(String lineName) {
        this.lines.dropCall(lineName);
    }

    public void dropCall(String lineName, String number) {
        this.lines.dropCall(lineName, number);
    }

    public void transferCall(String number) {
        this.lines.transferCall(number);
        if (number.equals(this.userid) || number.equals(this.service.getUserExtension())) {
            this.selfcall = true;
        }
        this.toLog("transferCall number=" + number + " selfcall=" + this.selfcall);
    }

    public void transferCall(String number, String lineName) {
        this.lines.transferCall(number, lineName);
        if (number.equals(this.userid) || number.equals(this.service.getUserExtension())) {
            this.selfcall = true;
        }
        this.toLog("transferCall number=" + number + " lineName=" + lineName + " selfcall=" + this.selfcall);
    }

    public void transferCall2(String lineName) {
        this.lines.transferCall2(lineName);
    }

    public void holdCall() {
        this.lines.holdCall();
    }

    public void resumeCall() {
        this.lines.resumeCall();
    }

    public void holdCall(String lineName) {
        this.lines.holdCall(lineName);
    }

    public void resumeCall(String lineName) {
        this.lines.resumeCall(lineName);
    }

    public void setActiveLine(String lineName) {
        this.lines.setActiveLine(lineName);
    }

    public void startVideo() {
        if (this.device.getVideoMode() != 0) {
            this.device.setVideoMode(0);
            this.lines.initCall("video_call");
        }
    }

    public void stopVideo() {
        if (this.device.getVideoMode() != -1) {
            this.device.setVideoMode(-1);
            this.lines.initCall("video_call");
        }
    }

    public boolean isCapturing() {
        return this.device.isCapturing();
    }

    public void setCapturing(boolean mode) {
        this.device.setCapturing(mode);
    }

    public void setVideoMode(int mode) {
        this.device.setVideoMode(mode);
    }

    public void processKey(char key) {
        this.lines.keyPressed(key);
    }

    public void processMenuCommand(String lineNAme, String cmd) {
        this.lines.menuCommand(lineNAme, cmd);
    }

    public void lineActionMenu(String lineName, int x, int y) {
        Line line = this.lines.getLine(lineName);
        if (line != null) {
            this.lines.lineActionMenu(line, x, y);
        }
    }

    private boolean channelConnected(CTIPort channel, String number) {
        Line activeLine;
        Line line = this.lines.getLine(channel.getPortName());
        if (line == (activeLine = this.lines.getActiveLine())) {
            return true;
        }
        if (activeLine != null && (activeLine.getState() == 3 || activeLine.getState() == 5)) {
            if (this.localConferenceMode) {
                this.joinToLocalConference(channel, activeLine, number);
                return false;
            }
            if (this.lines.join(activeLine, line)) {
                this.conferenceCreated(channel, activeLine);
                this.service.lineStateChanged(21, number, number, activeLine);
            }
            return true;
        }
        this.lines.setActiveLine(line);
        return true;
    }

    public void joinToLocalConference(CTIPort channel, Line line, String number) {
        this.toLog("joinToLocalConference channel=" + channel + "  line=" + line + " state=" + line.getState() + " number=" + number + " conferenceLine=" + this.conferenceLine);
        if (this.conferenceLine == null) {
            this.conferenceLine = line;
            channel.routeToMixer(null, 3);
            channel.connect(line.getName(), 1, "", "");
            this.conferenceCreated(channel, line);
        } else {
            channel.connect(line.getName(), 1, "", "");
        }
        this.service.lineStateChanged(21, number, number, line);
    }

    public void conferenceCreated(CTIPort channel, Line line) {
        line.lineStateChanged(5, "Connected");
        boolean video = channel.getCallProperties().containsKey("cti.VideoCodec2");
        this.service.lineStateChanged(19, "", video ? "videoconference" : "conference", line);
    }

    public void deleteLocalConference(CTIPort channel) {
        this.toLog("deleteLocalConference " + channel + " lines=" + channel.getConferencePorts());
        Enumeration en = channel.getConferencePorts().elements();
        while (en.hasMoreElements()) {
            CTIPort port = (CTIPort)en.nextElement();
            port.disconnect(16);
        }
    }

    public boolean dropConnectedParty(String number) {
        boolean dropped = false;
        for (CTIPort channel : this.iplines) {
            this.toLog("dropConnectedParty channel=" + channel + " connected=" + channel.getConnectedNumber() + " number=" + number);
            if (!number.equals(channel.getConnectedNumber())) continue;
            channel.disconnect(16);
            dropped = true;
        }
        return dropped;
    }

    public void joinToConference(String lineName) {
        this.joinToConference(this.lines.getActiveLine().getName(), lineName);
    }

    public void joinToConference(String lineName1, String lineName2) {
        Line activeLine = this.lines.getActiveLine();
        Line line1 = this.lines.getLine(lineName1);
        Line line2 = this.lines.getLine(lineName2);
        if (activeLine != line1 && activeLine != line2) {
            this.lines.setActiveLine(line1);
        }
        if (this.localConferenceMode) {
            CTIPort channel = this.manager.getPortByName(line1 == activeLine ? lineName2 : lineName1);
            String number = channel.getCallingNumber();
            if (number.length() == 0) {
                number = channel.getCalledNumber();
            }
            this.joinToLocalConference(channel, activeLine, number);
            channel.disconnect(16);
        } else if (this.lines.join(lineName1, lineName2)) {
            this.service.conferenceAdded(activeLine, (activeLine = this.lines.getActiveLine()) == line1 ? line2 : line1);
        }
    }

    public void callToConference(String number) {
        this.toLog("callToConference " + number + " localConferenceMode=" + this.localConferenceMode);
        this.lines.makeCall(number, false);
        this.incomingCallPresent();
    }

    public void setConnectedNumber(String linename, String number) {
        this.lines.setConnected(linename, number);
    }

    @Override
    public int processMessage(MimeMessage mimeMessage) {
        return 0;
    }

    @Override
    public boolean processResponse(String messageId, int messageStatus) {
        return true;
    }

    @Override
    public boolean processTimeout(String messageId) {
        return true;
    }

    @Override
    public void lineIdentityChanged(String number, String portName) {
        this.service.lineIdentityChanged(number, this.lines.getRingingLine());
    }

    @Override
    public void incomingCallRemoteAnswer() {
        for (CTIPort port : this.phoneLines) {
            if (port.getPort().getState() != 8) continue;
            if (this.pushcall) {
                this.pushcall = false;
                this.answerCall(port.getPortName(), false);
                break;
            }
            if (this.autoanswerMode <= 0) break;
            this.answerCall(port.getPortName(), this.autoanswerMode == 2);
            break;
        }
    }

    public void setAutoanswerMode(int b) {
        this.toLog("setAutoanswerMode " + b);
        this.autoanswerMode = b;
    }

    public int getAutoanswerMode() {
        return this.autoanswerMode;
    }

    public void setMaxIncomingLines(int n) {
        this.lines.setMaxinlines(n);
    }

    public void setRingtone(String ringtone) {
        this.device.setRingtone(ringtone);
    }

    public void setRingMode(int mode) {
        this.device.setRingMode(mode);
    }

    public int getMaxIncomingLines() {
        return this.lines.getMaxinlines();
    }

    public void setDeviceProperties(Map localProperties) throws Exception {
        Number ringLevel;
        Number playLevel;
        Integer jitter;
        Boolean aec;
        Boolean agcPlayback;
        Boolean agcRecord;
        Boolean vad;
        this.lines.setProperties(localProperties);
        String line = (String)localProperties.get("Speaker device");
        if (line != null) {
            try {
                this.device.setAudioSourceLine(line);
            }
            catch (Exception e) {
                ResourceStore.toLog(e.toString());
            }
        }
        if ((line = (String)localProperties.get("Microphone device")) != null) {
            try {
                this.device.setAudioTargetLine(line);
            }
            catch (Exception e) {
                ResourceStore.toLog(e.toString());
            }
        }
        if ((line = (String)localProperties.get("Ring device")) != null) {
            try {
                this.device.setPagingLine(line);
            }
            catch (Exception e) {
                ResourceStore.toLog(e.toString());
            }
        }
        if ((vad = (Boolean)localProperties.get("VAD")) != null) {
            this.device.setVAD(vad);
        }
        if ((agcRecord = (Boolean)localProperties.get("AGC IN")) != null) {
            this.device.setAGCRecord(agcRecord);
        }
        if ((agcPlayback = (Boolean)localProperties.get("AGC OUT")) != null) {
            this.device.setAGCPlayback(agcPlayback);
        }
        if ((aec = (Boolean)localProperties.get("AEC")) != null) {
            if (aec.booleanValue()) {
                Integer aectail = (Integer)localProperties.get("AEC tail");
                if (aectail == null) {
                    aectail = 0;
                }
                this.device.setAEC(aectail);
            } else {
                this.device.setAEC(-1);
            }
        }
        if ((jitter = (Integer)localProperties.get("minjitter")) == null) {
            jitter = 240;
        }
        this.setJitterBuffer(jitter);
        int bandwidth = 1;
        try {
            bandwidth = (Integer)localProperties.get("Connection speed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setCapabilities(bandwidth);
        String camname = (String)localProperties.get("Camera device");
        if (camname != null) {
            this.device.setCaptureChannel(camname, (String)localProperties.get("Camera format"), (String)localProperties.get("Video bitrate"));
        }
        this.device.setVideoCapabilities((Vector)localProperties.get("Video capabilities"));
        Number recordLevel = (Number)localProperties.get("Record level");
        if (recordLevel != null) {
            this.setRecordLevel(recordLevel.floatValue());
        }
        if ((playLevel = (Number)localProperties.get("Playback level")) != null) {
            this.setPlaybackLevel(playLevel.floatValue());
        }
        if ((ringLevel = (Number)localProperties.get("Ring level")) != null) {
            this.setRingLevel(ringLevel.floatValue());
        }
    }

    public void setSystemSoundsDir(String dir) {
        this.device.setSystemSoundsDir(dir);
    }

    public String[] getCaptureDeviceNames() {
        return this.device.getCaptureDeviceNames();
    }

    public List getCameraFormats(String chname) {
        return this.device.getCameraFormats(chname);
    }

    public String getCaptureFormat() {
        return this.device.getCaptureFormat();
    }

    public String setCaptureChannel(String chname, boolean landscape) throws Exception {
        return this.device.setCaptureChannel(chname, landscape);
    }

    public void setCaptureChannel(String deviceName, String format, String bitrate) throws Exception {
        this.device.setCaptureChannel(deviceName, format, bitrate);
    }

    public int getVideoMode() {
        return this.device.getVideoMode();
    }

    public void setAudioSessionState(boolean b) {
        this.device.setAudioSessionState(b);
    }

    public void setAudioPlaybackChannel(String deviceName) throws Exception {
        this.device.setAudioSourceLine(deviceName);
    }

    public String getAudioPlaybackChannel() {
        return this.device.getAudioSourceLine();
    }

    public void setAudioPagingChannel(String name) throws Exception {
        this.device.setPagingLine(name);
    }

    public String getAudioPagingChannel() {
        return this.device.getPagingLine();
    }

    public void setAudioCaptureChannel(String name) throws Exception {
        this.device.setAudioTargetLine(name);
    }

    public String getAudioCaptureChannel() {
        return this.device.getAudioTargetLine();
    }

    public void setMute(boolean mode) {
        this.device.setMute(mode);
    }

    public boolean getMute() {
        return this.device.getMute();
    }

    public void setVAD(boolean mode) {
        this.device.setVAD(mode);
    }

    public void setPlaybackLevel(float level) {
        this.device.setPlaybackLevel(level);
    }

    public float getPlaybackLevel() {
        return this.device.getPlaybackLevel();
    }

    public float getRingLevel() {
        return this.device.getRingLevel();
    }

    public void setRingLevel(float level) {
        this.device.setRingLevel(level);
    }

    public void setRecordLevel(float level) {
        this.device.setRecordLevel(level);
    }

    public float getRecordLevel() {
        return this.device.getRecordLevel();
    }

    public int getFileDuration(File file) {
        return this.device.getFileDuration(file);
    }

    public boolean playFile(File file, int fromSecond, int maxtime, String lineName) throws Exception {
        return this.device.playFile(file, fromSecond, maxtime, lineName);
    }

    public void playFile(File file) throws Exception {
        this.device.playFile(file);
    }

    public void playTone(String toneid, boolean paging) {
        if (paging) {
            this.device.playPagingTone(toneid);
        } else {
            this.device.playTone(toneid);
        }
    }

    public void stopPlay(String lineName) {
        this.device.stopPlay(lineName);
    }

    public void stopPlayRing() {
        this.device.stopPlayRing();
    }

    public void startRecord(OutputStream stream) {
        this.device.startRecord(stream, null);
    }

    public void stopRecord() {
        this.device.stopRecord(null);
    }

    public void call(String number, String line) {
        if (this.conferenceChannel != null) {
            this.conferenceChannel.dial(number);
        } else {
            this.device.transmitDigits(number, line);
        }
    }

    public String startSelectorConference(String id, boolean video) {
        this.device.setVideoMode(video ? 0 : -1);
        Line line = this.lines.getLine();
        this.lines.makeCall(id, line);
        this.incomingCallPresent();
        return line.getName();
    }

    public void stopSelectorConference(String id) {
    }

    public void setConferenceBitrate(int mode, String lineName) {
        this.sendConferenceControl(CC_BITRATE + mode + "</" + CC_BITRATE.substring(1), lineName);
    }

    public void addConferenceSpeaker(String user, String lineName) {
        this.sendConferenceControl("<microphone_on>" + user + "</" + "<microphone_on>".substring(1), lineName);
    }

    public void removeConferenceSpeaker(String user, String lineName) {
        this.sendConferenceControl("<microphone_off>" + user + "</" + "<microphone_off>".substring(2), lineName);
    }

    public void setConferenceMainSpeaker(String user, String lineName) {
        this.sendConferenceControl("<set_speaker>" + user + "</" + "<set_speaker>".substring(1), lineName);
    }

    public void setConferenceSpeakersMode(int mode, String lineName) {
        this.sendConferenceControl("<speakers_mode>" + mode + "</" + "<speakers_mode>".substring(1), lineName);
    }

    public void setConferencePromptMode(int mode, String lineName) {
        this.sendConferenceControl("<prompt_mode>" + mode + "</" + "<prompt_mode>".substring(1), lineName);
    }

    public void setConferenceLayoutMode(int mode, String lineName) {
        this.sendConferenceControl(CC_LAYOUT_MODE + mode + "</" + CC_LAYOUT_MODE.substring(1), lineName);
    }

    public void setConferenceViewMode(int mode, String lineName) {
        this.sendConferenceControl(CC_ROOT_VIEW + mode + "</" + CC_ROOT_VIEW.substring(1), lineName);
    }

    public void setConferenceLayout(int mode, String lineName) {
        this.sendConferenceControl(CC_LAYOUT_TYPE + mode + "</" + CC_LAYOUT_TYPE.substring(1), lineName);
    }

    public void setConferenceControl(int mode, String lineName) {
        this.sendConferenceControl(CC_SELECT_ACTION + mode + "</" + CC_SELECT_ACTION.substring(1), lineName);
    }

    public void sendConferenceControl(String cmd, String lineName) {
        CTIPort conferenceChannel = this.manager.getPortByName(lineName).getRoutedPort();
        if (conferenceChannel != null) {
            String str = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><conference_control>" + cmd + "</conference_control>";
            SipPort port = (SipPort)conferenceChannel.getPort();
            port.sendMediaControl(str);
        }
    }

    public int getConferenceControlActions(int x, int y, String lineName) {
        CTIPort conferenceChannel = this.manager.getPortByName(lineName).getRoutedPort();
        if (conferenceChannel == null) {
            return -1;
        }
        String str = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><conference_control><get_actions><x>" + x + "</x><y>" + y + "</y></" + CC_GET_ACTIONS.substring(2) + "</conference_control>";
        SipPort port = (SipPort)conferenceChannel.getPort();
        String retval = port.sendMediaControl(str, true);
        if (retval == null) {
            return -1;
        }
        int n = retval.indexOf(CC_RETURN_VALUE) + CC_RETURN_VALUE.length();
        return Integer.parseInt(retval.substring(n, retval.indexOf(60, n)));
    }

    public void toLog(String text) {
        ResourceStore.toLog(text);
    }

    class IPListener
    implements PortEventListener {
        CTIPort channel;

        IPListener(CTIPort channel) {
            this.channel = channel;
        }

        @Override
        public void processEvent(int event) {
            PhoneManager.this.toLog(this.channel + " event=" + event + " selfcall=" + PhoneManager.this.selfcall);
            if (event == 1) {
                Line line;
                String callingNumber = this.channel.getCallingNumber();
                if (PhoneManager.this.selfcall || PhoneManager.this.service.hasSIPDevice()) {
                    this.channel.disconnect(17);
                    PhoneManager.this.selfcall = false;
                    return;
                }
                try {
                    line = PhoneManager.this.setIncomingCall(this.channel.getCalledNumber(), callingNumber, this.channel.getCallProperties());
                }
                catch (IllegalStateException e) {
                    this.channel.disconnect(29);
                    return;
                }
                if (line == null) {
                    this.channel.disconnect(17);
                    return;
                }
                if (line.getReject()) {
                    this.channel.disconnect(21);
                    PhoneManager.this.lines.clearLine(line);
                    return;
                }
                PhoneManager.this.toLog(this.channel + " line=" + line + " auto=" + line.isAutoconnect() + " autoanswerMode=" + PhoneManager.this.autoanswerMode);
                String lineName = line.getName();
                String mode = "";
                if (line.isAutoconnect()) {
                    for (CTIPort port : PhoneManager.this.phoneLines) {
                        if (port.getPort().getState() != 4) continue;
                        lineName = port.getPortName();
                        mode = "$TARGET$";
                        PhoneManager.this.lineStateChanged(0, callingNumber, callingNumber, line);
                        break;
                    }
                } else if (callingNumber.endsWith("***")) {
                    if (callingNumber.startsWith("push")) {
                        PhoneManager.this.pushcall = true;
                    } else {
                        String camera;
                        if (PhoneManager.this.autoanswerMode == 0) {
                            PhoneManager.this.toLog("IpThread " + this.channel + " autoanswerMode=" + PhoneManager.this.autoanswerMode + " dropped");
                            this.channel.disconnect(17);
                            return;
                        }
                        if (PhoneManager.this.autoanswerMode == 2 && this.channel.getCallProperties().get("cti.VideoCodec") != null && (camera = (String)PhoneManager.this.service.getProperty("livetvcamera")) != null) {
                            PhoneManager.this.setVideoMode(1);
                            try {
                                PhoneManager.this.setCaptureChannel(camera, false);
                                PhoneManager.this.setCapturing(true);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                } else {
                    String description = (String)this.channel.getCallInfo().getAttribute("cti.CallingName");
                    if (description == null) {
                        description = callingNumber;
                    }
                    PhoneManager.this.lineStateChanged(2, callingNumber, callingNumber, line);
                }
                String result = this.channel.connect(lineName, 90, null, null, line.isAutoconnect() ? "***" : callingNumber, mode);
                if (result.equals("VOICE")) {
                    this.processCall(line.getName());
                } else if (result.equals("BUSY") && this.channel.getCause() == 23) {
                    this.channel.setOriginationNumber(this.channel.getForwardedNumber());
                    this.channel.disconnect(23);
                    PhoneManager.this.toLog("IpThread " + this.channel + " processCall=GC_CALL_REDIRECTED status=" + this.channel.getPortStatus());
                }
                PhoneManager.this.toLog("IpThread " + this.channel + " inconf=" + this.channel.inConference() + " conferenceLine=" + PhoneManager.this.conferenceLine);
                if (PhoneManager.this.conferenceLine != null) {
                    PhoneManager.this.service.lineStateChanged(22, callingNumber, callingNumber, PhoneManager.this.conferenceLine);
                } else if (line.getConferenceId() != null) {
                    PhoneManager.this.service.lineStateChanged(22, this.channel.getCalledNumber(), this.channel.getCalledNumber(), line);
                    line.setConferenceId(null);
                }
            } else if (event == 2) {
                String lineName = this.channel.getRoutedPortName();
                Line line = PhoneManager.this.lines.getLine(lineName);
                String connectedNumber = this.channel.getConnectedNumber();
                PhoneManager.this.setOutgoingCall(lineName, connectedNumber, this.channel.getCallProperties());
                this.processCall(lineName);
                PhoneManager.this.toLog("IpThread " + this.channel + " conf=" + this.channel.inConference() + " conferenceLine=" + PhoneManager.this.conferenceLine);
                if (PhoneManager.this.conferenceLine != null) {
                    PhoneManager.this.service.lineStateChanged(22, connectedNumber, connectedNumber, PhoneManager.this.conferenceLine);
                } else if (line.getConferenceId() != null) {
                    PhoneManager.this.service.lineStateChanged(22, this.channel.getCallingNumber(), this.channel.getCallingNumber(), line);
                    line.setConferenceId(null);
                }
            }
            this.channel.disconnect();
            PhoneManager.this.toLog("IpThread " + this.channel + " channel.close()");
        }

        private void processCall(String lineName) {
            Line line = PhoneManager.this.lines.getLine(lineName);
            String result = "";
            while (!this.channel.isDisconnected()) {
                result = this.channel.getDigits(1, 1, "");
                if (result.equals("TERMINATION")) {
                    PhoneManager.this.toLog("IpThread " + this.channel + " processCall=TERM_TERMINATED status=" + this.channel.getPortStatus() + " isRouted=" + this.channel.isRouted());
                    if (this.channel.getPortStatus().equals("on hold") || this.channel.getPortStatus().equals("resumed") || this.channel.isRouted()) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.channel.isRouted()) continue;
                    return;
                }
                if (result.equals("DISCONNECT")) break;
                if (!result.equals("DTMF")) continue;
                char digit = this.channel.getDigitsBuffer().charAt(0);
                PhoneManager.this.toLog(this.channel + " processCall=TERM_DTMF digit=" + digit);
                switch (digit) {
                    case '$': {
                        PhoneManager.this.lineStateChanged(10, this.channel.getConnectedNumber(), "Connected", lineName);
                        break;
                    }
                    case '~': {
                        PhoneManager.this.lineStateChanged(9, this.channel.getConnectedNumber(), "Connected", lineName);
                        break;
                    }
                    case 'h': {
                        PhoneManager.this.lineStateChanged(4, this.channel.getConnectedNumber(), "Connected", lineName);
                        break;
                    }
                    case '%': {
                        PhoneManager.this.lineStateChanged(5, this.channel.getConnectedNumber(), "Connected", lineName);
                        break;
                    }
                    case '/': {
                        PhoneManager.this.service.lineIdentityChanged(this.channel.getConnectedPartyNumber(), PhoneManager.this.lines.getLine(lineName));
                    }
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            PhoneManager.this.toLog("IpThread " + this.channel + " processCall result=" + result + " dis=" + this.channel.isDisconnected());
        }
    }

    class PhoneListener
    implements PortEventListener {
        private CTIPort channel;

        PhoneListener(CTIPort channel) throws Exception {
            this.channel = channel;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void processEvent(int event) {
            block30: {
                int i;
                String termmask;
                Object phone;
                String calling;
                boolean conf;
                Object called;
                block34: {
                    block31: {
                        int n;
                        block33: {
                            block32: {
                                PhoneManager.this.toLog(this.channel + " event=" + event + " state=" + PhoneManager.this.reconnecting);
                                if (event != 1) break block31;
                                this.channel.answerCall();
                                called = this.channel.getCalledNumber();
                                if (((String)called).length() == 0) break block30;
                                conf = false;
                                calling = PhoneManager.this.userid;
                                phone = called;
                                n = ((String)phone).indexOf("@");
                                if (n == -1) break block32;
                                if (((String)called).startsWith("sip:") || ((String)called).startsWith("sips:")) {
                                    called = ((String)called).replace(':', '=').replace('@', '&');
                                    break block33;
                                } else {
                                    String ip = ((String)phone).substring(n + 1);
                                    phone = ((String)phone).substring(0, n);
                                    n = ip.indexOf(";");
                                    if (n != -1) {
                                        calling = ip.substring(n + 1);
                                        called = (String)phone + "@" + ip.substring(0, n);
                                    }
                                }
                                break block33;
                            }
                            if (((String)phone).startsWith("TRUNK")) {
                                phone = ((String)phone).substring(((String)phone).indexOf(42) + 1);
                            } else if (((String)phone).startsWith("CONFERENCE")) {
                                phone = ((String)phone).substring(((String)phone).indexOf(42) + 1);
                                conf = true;
                            } else {
                                n = ((String)phone).indexOf("_");
                                if (n != -1) {
                                    phone = ((String)phone).substring(0, n);
                                }
                            }
                        }
                        n = ((String)phone).indexOf(":");
                        if (n != -1 && !((String)phone).startsWith("sip")) {
                            phone = ((String)phone).substring(n + 1);
                        }
                        PhoneManager.this.lineStateChanged(1, (String)phone, (String)phone, this.channel.getPortName());
                        termmask = "\u001b,!";
                        i = 0;
                        break block34;
                    }
                    if (event == 2) {
                        Line line;
                        Line activeLine = PhoneManager.this.lines.getActiveLine();
                        PhoneManager.this.toLog("PhoneThread CONNECT line=" + this.channel.getPortName() + " activeLine=" + activeLine + " calling=" + this.channel.getCallingNumber() + " called=" + this.channel.getCalledNumber());
                        if (activeLine != null && (line = PhoneManager.this.lines.getLine(this.channel.getPortName())) != activeLine) {
                            PhoneManager.this.lines.setActiveLine(line);
                        }
                        PhoneManager.this.lineStateChanged(3, this.channel.getCallingNumber(), "Connected", this.channel.getPortName());
                        this.processCall();
                    }
                    break block30;
                }
                while (i++ < 25 && (PhoneManager.this.connecting || PhoneManager.this.reconnecting)) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (calling == null) {
                    calling = PhoneManager.this.userid;
                }
                PhoneManager.this.selfcall = ((String)phone).equals(PhoneManager.this.userid) || ((String)phone).equals(PhoneManager.this.service.getUserExtension());
                this.channel.setCalledNumber((String)phone);
                try {
                    String result = null;
                    for (int k = 0; k < 5; ++k) {
                        String tone = PhoneManager.this.service.isInternalNumber((String)called) ? "INTERNAL" : "EXTERNAL";
                        result = this.channel.connect((String)called, 90, tone, termmask, calling);
                        PhoneManager.this.toLog("PhoneThread line=" + this.channel.getPortName() + " called=" + (String)called + " calling=" + calling + " result=" + result + " cause=" + this.channel.getCause(result));
                        if (!result.equals("BUSY") || this.channel.getCause() != 23 && this.channel.getCause() != 22) break;
                        called = this.channel.getForwardedNumber();
                    }
                    if (result.equals("VOICE")) {
                        if (PhoneManager.this.channelConnected(this.channel, (String)phone)) {
                            if (conf) {
                                PhoneManager.this.lineStateChanged(5, (String)phone, "Conference", this.channel.getPortName());
                            } else {
                                PhoneManager.this.lineStateChanged(3, (String)phone, "Connected", this.channel.getPortName());
                            }
                            this.processCall();
                        }
                        break block30;
                    }
                    if (!result.equals("DISCONNECT")) {
                        if (!result.equals("TERMINATION")) {
                            PhoneManager.this.lineStateChanged(18, (String)phone, ServiceManager.getCauseDescription(this.channel.getCause(result)), this.channel.getPortName());
                            if (result.equals("BUSY") && (this.channel.getCause() == 17 || this.channel.getCause() == 21 || this.channel.getCause() == 19)) {
                                this.channel.playTone("Reorder", 2);
                                break block30;
                            }
                            if (result.equals("STOPPED") || this.channel.getCause() == 19) break block30;
                            Line line = PhoneManager.this.lines.getActiveLine();
                            if (PhoneManager.this.lines.getLine(this.channel.getPortName()) == line || line == null || !((String)phone).equals(line.getConnectedNumber())) {
                                this.channel.playTone("SIT Tone", 2);
                            }
                            break block30;
                        }
                    }
                    if (result.equals("DISCONNECT")) {
                        this.channel.setCause(0);
                    }
                }
                catch (Throwable t) {
                    PhoneManager.this.toLog("processEvent: " + t);
                }
            }
            PhoneManager.this.toLog("PhoneThread close line=" + this.channel.getPortName() + " conferenceLine=" + PhoneManager.this.conferenceLine);
            if (PhoneManager.this.lines.getLine(this.channel.getPortName()) == PhoneManager.this.conferenceLine) {
                PhoneManager.this.deleteLocalConference(this.channel);
                PhoneManager.this.conferenceLine = null;
                PhoneManager.this.lineStateChanged(20, "", "", this.channel.getPortName());
            }
            String description = this.channel.getConnectionTime() > 0 ? "" : ServiceManager.getCauseDescription(this.channel.getCause());
            PhoneManager.this.lineStateChanged(8, "Disconnect", description, this.channel.getPortName());
            this.channel.disconnect();
            PhoneManager.this.selfcall = false;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            PhoneManager.this.lineStateChanged(0, "", "", this.channel.getPortName());
        }

        private void processCall() {
            String brk;
            boolean fax = false;
            boolean onhold = false;
            String string = brk = PhoneManager.this.localConferenceMode ? "!,^" : "";
            while (!this.channel.isDisconnected()) {
                String result = this.channel.getDigits(15, 3, brk);
                if (result.equals("FAX")) {
                    PhoneManager.this.lineStateChanged(12, "", "", this.channel.getPortName());
                    fax = true;
                    continue;
                }
                if (result.equals("DTMF")) {
                    String number = this.channel.getDigitsBuffer();
                    String breakDigit = this.channel.getBreakDigit();
                    PhoneManager.this.toLog("PhoneThread " + this.channel + " result=TERM_DTMF number=" + number + " breakDigit=" + breakDigit);
                    if (number.length() == 0) {
                        number = breakDigit;
                    }
                    if (String.valueOf('!').equals(breakDigit)) {
                        onhold = !onhold;
                        PhoneManager.this.lineStateChanged(onhold ? 4 : 9, this.channel.getConnectedNumber(), "Connected", this.channel.getPortName());
                    } else if (String.valueOf('^').equals(breakDigit)) {
                        onhold = false;
                        PhoneManager.this.lineStateChanged(9, this.channel.getConnectedNumber(), "Connected", this.channel.getPortName());
                    }
                    try {
                        this.channel.connect(number, 30, "", "");
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (result.equals("TERMINATION")) {
                    PhoneManager.this.toLog("PhoneThread " + this.channel + " processCall=TERM_TERMINATED status=" + this.channel.getPortStatus() + " routed=" + this.channel.isRouted());
                    if (fax) {
                        PhoneManager.this.lineStateChanged(13, "", "", this.channel.getPortName());
                        fax = false;
                        continue;
                    }
                    if (this.channel.getPortStatus().equals("on hold") || this.channel.getPortStatus().equals("resumed") || this.channel.isRouted()) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.channel.isRouted()) continue;
                    break;
                }
                if (!result.equals("DISCONNECT")) continue;
                break;
            }
        }
    }
}

