/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.phone.audio.impl;

import com.smile.telephony.PipeInputStream;
import com.smile.telephony.audio.SignalProcessor;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.CompoundControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import smile.cti.phone.DeviceListener;
import smile.cti.phone.audio.AudioSystem;
import smile.util.ResourceStore;

public class AudioDevice
implements AudioSystem {
    public static final int MAIN_LINE = 0;
    public static final int PAGING_LINE = 1;
    private static byte[] GAUSSIAN = new byte[300000];
    private Vector lines;
    private Hashtable slines;
    private Hashtable tlines;
    private Hashtable scontrols;
    private Hashtable tcontrols;
    private AudioFormat format;
    private SourceDataLine sLine;
    private TargetDataLine tLine;
    private String sLineName;
    private String tLineName;
    private String pLineName;
    private Player player;
    private Recorder recorder;
    boolean playing;
    boolean recording;
    private int sbufSize = 120;
    private int tbufSize = 120;
    private int frameTime = 10;
    private InputStream input;
    private OutputStream output;
    private boolean released = false;
    private boolean mute = false;
    private boolean vad = false;
    private int agcPlaybackMode = 3;
    private int agcRecordMode = 3;
    private boolean agcPlayback;
    private boolean agcRecord;
    private boolean aecEnabled;
    private int stream_delay_ms = 140;
    private SignalProcessor spRecord;
    private SignalProcessor spPlayback;
    private int reclevel;
    private int playlevel;
    private float recordlevel = 0.5f;
    private boolean sLineStarted;
    private boolean tLineStarted;
    private boolean alwaysRunning;
    private DeviceListener deviceListener;
    private String selectedPlaybackLine;
    private String selectedCaptureLine;
    private boolean absPlayLevel;

    public AudioDevice() {
        int sampleRate = 48000;
        this.format = new AudioFormat(sampleRate, 16, 1, true, false);
        this.spRecord = SignalProcessor.getInstance(this.frameTime * 8, 8000, sampleRate);
        this.spRecord.setResampler((int)this.format.getSampleRate(), 8000);
        this.spRecord.setFilter();
        this.spRecord.setNoiseSuppression(2);
        this.spRecord.setEchoCancellation(this.stream_delay_ms);
        this.spPlayback = SignalProcessor.getInstance(this.frameTime * 8, 8000, sampleRate);
        this.spPlayback.setResampler(8000, (int)this.format.getSampleRate());
        this.spPlayback.setNoiseSuppression(1);
        this.spPlayback.setVAD(1);
        try {
            this.spPlayback.setAGCLevel(3);
            this.spPlayback.setAGCCompressionGain(12);
            this.spRecord.setAGCLevel(6);
            this.spRecord.setAGCCompressionGain(9);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String osname = System.getProperty("os.name").toLowerCase();
        this.absPlayLevel = osname.contains("windows");
        this.findAudioDevices();
        this.setLines();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    AudioDevice.this.checkLines();
                }
                catch (Exception e) {
                    ResourceStore.error("checkLines", e);
                }
            }
        };
        new Timer().scheduleAtFixedRate(task, 10000L, 3000L);
    }

    private void checkLines() {
        HashSet oldlines = new HashSet(this.lines);
        if (!this.findAudioDevices()) {
            return;
        }
        HashSet newlines = new HashSet(this.lines);
        HashSet<String> added = new HashSet<String>();
        HashSet<String> removed = new HashSet<String>();
        for (String line : oldlines) {
            if (line.startsWith("Port ") || newlines.contains(line)) continue;
            removed.add(line);
        }
        block1: for (String line : newlines) {
            if (line.startsWith("Port ") || oldlines.contains(line)) continue;
            added.add(line);
            for (String str : removed) {
                if (!line.startsWith(str)) continue;
                added.remove(line);
                removed.remove(str);
                continue block1;
            }
        }
        String sname = null;
        for (String str : removed) {
            int n = str.indexOf(40);
            if (n != -1 && n < str.length() - 1 && (n = (str = str.substring(n + 1)).lastIndexOf(41)) != -1) {
                str = str.substring(0, n);
            }
            if (sname == null || str.startsWith(sname)) {
                sname = str;
                continue;
            }
            if (sname.startsWith(str)) continue;
            this.deviceListener.deviceRemoved(str);
        }
        if (sname != null) {
            this.deviceListener.deviceRemoved(sname);
        }
        String tname = null;
        for (String str : added) {
            int n = str.indexOf(40);
            if (n != -1 && n < str.length() - 1 && (n = (str = str.substring(n + 1)).lastIndexOf(41)) != -1) {
                str = str.substring(0, n);
            }
            if (tname == null || str.startsWith(tname)) {
                tname = str;
                continue;
            }
            if (tname.startsWith(str) || oldlines.isEmpty()) continue;
            this.deviceListener.deviceAdded(str);
        }
        ResourceStore.toLog("checkLines added=" + added + " removed=" + removed + " tname=" + tname + " sname=" + sname);
        if (tname != null && !oldlines.isEmpty()) {
            this.deviceListener.deviceAdded(tname);
        }
        this.setLines();
    }

    private void setLines() {
        ResourceStore.toLog("lines=" + this.lines + " selectedPlaybackLine=" + this.selectedPlaybackLine + " selectedCaptureLine=" + this.selectedCaptureLine);
        Vector slines = (Vector)this.lines.clone();
        if (this.selectedPlaybackLine != null && slines.remove(this.selectedPlaybackLine)) {
            slines.insertElementAt(this.selectedPlaybackLine, 0);
        }
        for (int i = 0; i < slines.size(); ++i) {
            String name = (String)slines.get(i);
            if (name.startsWith("Port ")) continue;
            try {
                this.setSourceLine(name);
            }
            catch (Exception e) {
                ResourceStore.toLog(name + ": " + e);
            }
            if (this.sLine != null) break;
        }
        Vector tlines = (Vector)this.lines.clone();
        if (this.selectedCaptureLine != null && tlines.remove(this.selectedCaptureLine)) {
            tlines.insertElementAt(this.selectedCaptureLine, 0);
        } else if (this.sLineName != null && tlines.remove(this.sLineName)) {
            tlines.insertElementAt(this.sLineName, 0);
        }
        for (int i = 0; i < tlines.size(); ++i) {
            String name = (String)tlines.get(i);
            if (name.startsWith("Port ")) continue;
            try {
                this.setTargetLine(name);
                break;
            }
            catch (Exception e) {
                ResourceStore.toLog(name + ": " + e);
            }
        }
        ResourceStore.toLog("slines=" + this.slines + "\ntlines=" + this.tlines + "\nscontrols=" + this.scontrols + "\ntcontrols=" + this.tcontrols);
    }

    public void finalize() {
        this.stopPlayer();
        this.stopRecorder();
    }

    public String getSourceLineName() {
        return this.sLineName;
    }

    public String getTargetLineName() {
        return this.tLineName;
    }

    public String getPagingLineName() {
        return this.pLineName;
    }

    public void setSourceLine(String name) throws LineUnavailableException {
        SourceDataLine line = (SourceDataLine)this.slines.get(name);
        if (line == null) {
            for (String key : this.slines.keySet()) {
                if (!name.startsWith(key) && !key.startsWith(name)) continue;
                line = (SourceDataLine)this.slines.get(key);
                break;
            }
        }
        if (line == null) {
            throw new LineUnavailableException(name + " source line not available");
        }
        if (line != this.sLine) {
            if (this.sLine != null) {
                this.stopPlayer();
            }
            this.sLine = line;
        }
        if (this.player == null) {
            this.startPlayer();
        }
        this.sLineName = name;
        if (this.pLineName == null) {
            this.pLineName = this.sLineName;
        }
        ResourceStore.toLog("setSourceLine " + name + " line=" + this.sLine);
    }

    public void setTargetLine(String name) throws LineUnavailableException {
        TargetDataLine line = (TargetDataLine)this.tlines.get(name);
        if (line == null) {
            for (String key : this.tlines.keySet()) {
                if (!name.startsWith(key) && !key.startsWith(name)) continue;
                line = (TargetDataLine)this.tlines.get(key);
                break;
            }
        }
        if (line == null) {
            throw new LineUnavailableException(name + " target line not available");
        }
        if (line != this.tLine) {
            if (this.tLine != null) {
                this.stopRecorder();
            }
            this.tLine = line;
            this.setCaptureLevel(this.recordlevel);
        }
        if (this.recorder == null) {
            this.startRecorder();
        }
        this.tLineName = name;
        ResourceStore.toLog("setTargetLine " + name + " line=" + this.tLine);
    }

    public void setPagingLine(String name) throws LineUnavailableException {
        this.pLineName = name;
        ResourceStore.toLog("setPagingLine " + name);
    }

    public void startPlayer() throws LineUnavailableException {
        this.player = new Player();
        this.player.setPriority(10);
        this.playing = true;
        this.released = false;
        this.player.start();
        ResourceStore.toLog("startPlayer " + this.player);
    }

    public void stopPlayer() {
        ResourceStore.toLog("stopPlayer " + this.player);
        this.playing = false;
        if (this.player != null && this.player.isAlive()) {
            try {
                this.player.join(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.player.isAlive()) {
                this.sLine.stop();
                try {
                    this.player.join(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.player = null;
    }

    public void startRecorder() throws LineUnavailableException {
        this.recorder = new Recorder();
        this.recorder.setPriority(10);
        this.recording = true;
        this.released = false;
        this.recorder.start();
        ResourceStore.toLog("startRecorder " + this.recorder);
    }

    public void stopRecorder() {
        ResourceStore.toLog("stopRecorder " + this.recorder);
        this.recording = false;
        if (this.recorder != null && this.recorder.isAlive()) {
            try {
                this.recorder.join(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.recorder.isAlive()) {
                this.tLine.stop();
                try {
                    this.recorder.join(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.recorder = null;
    }

    @Override
    public void setMute(boolean state) {
        this.mute = state;
    }

    @Override
    public boolean getMute() {
        return this.mute;
    }

    public void setPlaybackBuffer(int millis) {
        this.sbufSize = millis;
    }

    public void setRecordBuffer(int millis) {
        this.tbufSize = millis;
    }

    public void setAGCRecordMode(int mode) {
        this.agcRecordMode = mode;
    }

    public void setAGCPlaybackMode(int mode) {
        this.agcPlaybackMode = mode;
    }

    @Override
    public void setAEC(int value) {
        boolean bl = this.aecEnabled = value != -1;
        if (value == 0) {
            value = this.stream_delay_ms;
        }
        if (this.recorder != null) {
            this.recorder.setAEC(value);
        } else {
            this.stream_delay_ms = value;
        }
        ResourceStore.toLog("setAEC:" + value + " recorder=" + this.recorder);
    }

    public boolean getAEC() {
        return this.aecEnabled;
    }

    public boolean getAGCPlayback() {
        return this.agcPlayback;
    }

    public boolean getAGCRecord() {
        return this.agcRecord;
    }

    @Override
    public Enumeration<String> getCaptureLines() {
        Vector<String> v = new Vector<String>();
        Enumeration en = this.lines.elements();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            if (!this.tlines.containsKey(name) || v.contains(name) || name.startsWith("Port ")) continue;
            v.add(name);
        }
        return v.elements();
    }

    @Override
    public Enumeration<String> getPlaybackLines() {
        Vector<String> v = new Vector<String>();
        Enumeration en = this.lines.elements();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            if (!this.slines.containsKey(name) || v.contains(name) || name.startsWith("Port ")) continue;
            v.add(name);
        }
        return v.elements();
    }

    @Override
    public void openCaptureLine(String linename) throws Exception {
        ResourceStore.toLog("openCaptureLine " + linename);
        this.selectedCaptureLine = linename;
        this.setTargetLine(linename);
    }

    @Override
    public void openPlaybackLine(String linename) throws Exception {
        ResourceStore.toLog("openPlaybackLine " + linename);
        this.selectedPlaybackLine = linename;
        this.setSourceLine(linename);
    }

    @Override
    public void closeCaptureLine() {
        this.stopRecorder();
    }

    @Override
    public void closePlaybackLine() {
        this.stopPlayer();
    }

    @Override
    public void startCapture(OutputStream stream) {
        this.output = stream;
        ResourceStore.toLog("startCapture output=" + this.output + " tLineStarted=" + this.tLineStarted);
    }

    @Override
    public void startPlayback(InputStream stream) {
        this.input = stream;
        ResourceStore.toLog("startPlayback input=" + this.input + " sLineStarted=" + this.sLineStarted);
    }

    @Override
    public void stopCapture() {
        ResourceStore.toLog("stopCapture output=" + this.output + " tLineStarted=" + this.tLineStarted);
        this.output = null;
    }

    @Override
    public void stopPlayback() {
        ResourceStore.toLog("stopPlayback input=" + this.input + " sLineStarted=" + this.sLineStarted);
        if (this.input != null && this.sLine != null && this.sLine.isRunning()) {
            this.sLine.stop();
        }
        this.input = null;
    }

    @Override
    public void setCaptureAGC(boolean mode) {
        this.agcRecord = mode;
        if (this.recorder != null) {
            this.recorder.setAGC(mode ? this.agcRecordMode : 0);
        }
    }

    @Override
    public void setPlaybackAGC(boolean mode) {
        this.agcPlayback = mode;
        if (this.player != null) {
            this.player.setAGC(mode ? this.agcPlaybackMode : 0);
        }
    }

    @Override
    public void setVAD(boolean mode) {
        this.vad = mode;
    }

    @Override
    public int getPlaybackStreamLevel() {
        return this.playlevel;
    }

    @Override
    public int getCaptureStreamLevel() {
        return this.reclevel;
    }

    @Override
    public void setCaptureLevel(float level) {
        this.setFloatControlLevel(this.getRecordControls(), level, true);
        this.recordlevel = level;
    }

    @Override
    public void setPlaybackLevel(float level) {
        this.setFloatControlLevel(this.getPlaybackControls(), level, this.absPlayLevel);
    }

    @Override
    public float getCaptureLevel() {
        return this.getFloatControlLevel(this.getRecordControls());
    }

    @Override
    public float getPlaybackLevel() {
        return this.getFloatControlLevel(this.getPlaybackControls());
    }

    private void setFloatControlLevel(List<FloatControl> controls, float level, boolean abs) {
        for (int i = 0; i < controls.size(); ++i) {
            float value;
            FloatControl fc = controls.get(i);
            float f = value = abs ? level : level * fc.getValue();
            if (Math.abs(value) < 1.0f) {
                value = (fc.getMaximum() - fc.getMinimum()) * value + fc.getMinimum();
                if (value > fc.getMaximum()) {
                    value = fc.getMaximum();
                } else if (value < fc.getMinimum()) {
                    value = fc.getMinimum();
                }
            } else if (level >= fc.getMaximum()) {
                value = fc.getMaximum();
            } else if (level <= fc.getMinimum()) {
                value = fc.getMinimum();
            }
            ResourceStore.toLog("setFloatControlLevel " + level + " fc=" + fc.getValue() + " value=" + value);
            fc.setValue(value);
        }
    }

    private float getFloatControlLevel(List<FloatControl> controls) {
        float value = 0.0f;
        for (int i = 0; i < controls.size(); ++i) {
            FloatControl fc = controls.get(i);
            float f = (fc.getValue() - fc.getMinimum()) / (fc.getMaximum() - fc.getMinimum());
            if (!(f > value)) continue;
            value = f;
        }
        return value;
    }

    private void amp(byte[] pcm, double d) {
        for (int i = 0; i < pcm.length; i += 2) {
            int s = (int)((double)(pcm[i + 1] << 8 | pcm[i] & 0xFF) * d);
            pcm[i] = (byte)(s & 0xFF);
            pcm[i + 1] = (byte)(s >> 8);
        }
    }

    @Override
    public void setState(boolean state) {
    }

    @Override
    public void setDeviceListener(DeviceListener listener) {
        this.deviceListener = listener;
    }

    private int getLevel(byte[] data) {
        int midvalue = 0;
        for (int i = 0; i < data.length; i += 2) {
            midvalue += Math.abs(data[i + 1] << 8 | data[i] & 0xFF);
        }
        return midvalue / data.length;
    }

    public boolean findAudioDevices() {
        Vector<String> lines = new Vector<String>();
        Mixer.Info[] mixInfo = javax.sound.sampled.AudioSystem.getMixerInfo();
        for (int i = 0; i < mixInfo.length; ++i) {
            String line = AudioDevice.checkName(mixInfo[i].getName());
            if (line == null || lines.contains(line)) continue;
            lines.add(line);
        }
        if (lines.equals(this.lines)) {
            return false;
        }
        Hashtable<String, Line> slines = new Hashtable<String, Line>();
        Hashtable<Object, Line> tlines = new Hashtable<Object, Line>();
        Hashtable<Object, Vector> scontrols = new Hashtable<Object, Vector>();
        Hashtable<Object, Vector> tcontrols = new Hashtable<Object, Vector>();
        for (int i = 0; i < mixInfo.length; ++i) {
            Vector controls;
            Object key;
            Line line;
            int j;
            String mixName = AudioDevice.checkName(mixInfo[i].getName());
            if (mixName == null) continue;
            ResourceStore.toLog("MIXER " + mixName);
            Mixer mixer = javax.sound.sampled.AudioSystem.getMixer(mixInfo[i]);
            Line.Info[] info = mixer.getSourceLineInfo();
            for (j = 0; j < info.length; ++j) {
                try {
                    line = mixer.getLine(info[j]);
                    key = mixName;
                    if (line instanceof SourceDataLine) {
                        while (slines.containsKey(key)) {
                            key = (String)key + " ";
                        }
                        slines.put((String)key, line);
                        controls = this.getControls(line, FloatControl.Type.VOLUME);
                        if (!controls.isEmpty()) {
                            scontrols.put(key, controls);
                        }
                        ResourceStore.toLog("SourceDataLine: " + info[j] + " controls=" + controls);
                        continue;
                    }
                    controls = this.getControls(line, FloatControl.Type.VOLUME);
                    if (!controls.isEmpty()) {
                        while (tcontrols.containsKey(key)) {
                            key = (String)key + " ";
                        }
                        tcontrols.put(key, controls);
                    }
                    ResourceStore.toLog("SourcePort: " + info[j] + " controls=" + controls);
                    continue;
                }
                catch (Exception e) {
                    ResourceStore.toLog(e.toString());
                }
            }
            info = mixer.getTargetLineInfo();
            for (j = 0; j < info.length; ++j) {
                try {
                    line = mixer.getLine(info[j]);
                    key = mixName;
                    if (line instanceof TargetDataLine) {
                        while (tlines.containsKey(key)) {
                            key = (String)key + " ";
                        }
                        tlines.put(key, line);
                        controls = this.getControls(line, FloatControl.Type.VOLUME);
                        if (!controls.isEmpty()) {
                            tcontrols.put(key, controls);
                        }
                        ResourceStore.toLog("TargetDataLine: " + info[j] + " controls=" + controls);
                        continue;
                    }
                    if (!(line instanceof Port) || line.getLineInfo().matches(Port.Info.MICROPHONE)) continue;
                    controls = this.getControls(line, FloatControl.Type.VOLUME);
                    if (!controls.isEmpty()) {
                        while (scontrols.containsKey(key)) {
                            key = (String)key + " ";
                        }
                        scontrols.put(key, controls);
                    }
                    ResourceStore.toLog("TargetPort: " + info[j] + " controls=" + controls);
                    continue;
                }
                catch (Exception e) {
                    ResourceStore.toLog(e.toString());
                }
            }
        }
        this.lines = lines;
        this.slines = slines;
        this.tlines = tlines;
        this.scontrols = scontrols;
        this.tcontrols = tcontrols;
        return true;
    }

    private Vector getControls(Line line, Control.Type type) {
        Vector<Control> controls = new Vector<Control>();
        try {
            line.open();
            Control[] c = line.getControls();
            boolean ca = false;
            for (int i = 0; i < c.length; ++i) {
                if (c[i] instanceof CompoundControl) {
                    if (ca) continue;
                    Control[] c1 = ((CompoundControl)c[i]).getMemberControls();
                    for (int j = 0; j < c1.length; ++j) {
                        if (!c1[j].getType().equals(type)) continue;
                        controls.addElement(c1[j]);
                        ca = true;
                    }
                    continue;
                }
                if (!c[i].getType().equals(type)) continue;
                controls.addElement(c[i]);
            }
            if (line instanceof DataLine || controls.isEmpty()) {
                line.close();
            }
        }
        catch (Exception e) {
            ResourceStore.error("getControls", e);
        }
        return controls;
    }

    private List<FloatControl> getPlaybackControls() {
        ArrayList<FloatControl> list = new ArrayList<FloatControl>();
        if (this.sLineName != null) {
            Enumeration en = this.scontrols.keys();
            while (en.hasMoreElements()) {
                String sname;
                String name = (String)en.nextElement();
                Vector controls = (Vector)this.scontrols.get(name);
                if (controls == null || controls.isEmpty()) continue;
                int n = name.indexOf(91);
                String string = sname = n != -1 ? name.substring(0, n).trim() : name;
                if (this.sLineName.indexOf(sname) != -1 || name.startsWith("Port ") && this.sLineName.indexOf(sname.substring(5)) != -1) {
                    list.clear();
                    list.add((FloatControl)controls.get(0));
                    break;
                }
                list.add((FloatControl)controls.get(0));
            }
        }
        if (list.isEmpty()) {
            list.add((FloatControl)this.sLine.getControl(FloatControl.Type.MASTER_GAIN));
        }
        return list;
    }

    private List<FloatControl> getRecordControls() {
        ArrayList<FloatControl> list = new ArrayList<FloatControl>();
        if (this.tLineName != null) {
            Enumeration en = this.tcontrols.keys();
            while (en.hasMoreElements()) {
                String tname;
                String name = (String)en.nextElement();
                Vector controls = (Vector)this.tcontrols.get(name);
                if (controls == null || controls.isEmpty()) continue;
                int n = name.indexOf(91);
                String string = tname = n != -1 ? name.substring(0, n).trim() : name;
                if (this.tLineName.indexOf(tname) != -1 || name.startsWith("Port ") && this.tLineName.indexOf(tname.substring(5)) != -1) {
                    list.clear();
                    list.add((FloatControl)controls.get(0));
                    break;
                }
                list.add((FloatControl)controls.get(0));
            }
        }
        return list;
    }

    protected static String checkName(String name) {
        if (name.startsWith("Primary Sound")) {
            return "Primary Sound Device";
        }
        if (name.equals("Unknown Name")) {
            return null;
        }
        return name.trim();
    }

    static {
        Random random = new Random();
        int max = 4;
        int i = 0;
        do {
            int n = (int)(Math.round((double)max * random.nextDouble()) - (long)(max / 2));
            AudioDevice.GAUSSIAN[i++] = (byte)(n & 0xFF);
            AudioDevice.GAUSSIAN[i++] = (byte)(n >> 8);
        } while (i < GAUSSIAN.length);
    }

    class Recorder
    extends Thread {
        int frameTime = 10;

        Recorder() {
        }

        public void setAEC(int value) {
            AudioDevice.this.spRecord.setEchoCancellation(value);
        }

        public void setAGC(int mode) {
            AudioDevice.this.spRecord.setAGC(mode);
        }

        public void setNoiseSuppression(int mode) {
            AudioDevice.this.spRecord.setNoiseSuppression(mode);
        }

        @Override
        public void run() {
            ResourceStore.toLog("Recorder line thread started tbuf=" + AudioDevice.this.tLine.getBufferSize() + " frameRate=" + AudioDevice.this.tLine.getFormat().getFrameRate() + " frameSize=" + AudioDevice.this.tLine.getFormat().getFrameSize() + " sampleRate=" + AudioDevice.this.tLine.getFormat().getSampleRate() + " vad=" + AudioDevice.this.vad);
            AudioDevice.this.spRecord.setVAD(AudioDevice.this.vad ? 1 : 0);
            AudioDevice.this.spRecord.setEchoCancellation(AudioDevice.this.stream_delay_ms);
            int linebufsize = (int)((float)(AudioDevice.this.tbufSize * (AudioDevice.this.format.getSampleSizeInBits() / 8)) * (AudioDevice.this.format.getSampleRate() / 1000.0f));
            int bits = AudioDevice.this.format.getSampleSizeInBits();
            int samples = (int)(AudioDevice.this.format.getSampleRate() / 1000.0f);
            int bufsize = this.frameTime * bits * samples / 8;
            byte[] data = new byte[bufsize];
            byte[] datar = new byte[this.frameTime * 16];
            byte[] no_input = new byte[this.frameTime * 16];
            for (int i = 0; i < no_input.length; ++i) {
                no_input[i] = 0;
            }
            int s = 0;
            LineListener listener = new LineListener(){

                @Override
                public void update(LineEvent event) {
                    ResourceStore.toLog("Recorder Line update:" + event.getType());
                    if (event.getType() == LineEvent.Type.START) {
                        AudioDevice.this.tLineStarted = true;
                    } else if (event.getType() == LineEvent.Type.STOP) {
                        AudioDevice.this.tLineStarted = false;
                    }
                }
            };
            AudioDevice.this.tLine.addLineListener(listener);
            while (AudioDevice.this.recording) {
                try {
                    int numBytesRead;
                    if (AudioDevice.this.output == null) {
                        AudioDevice.this.reclevel = 0;
                        ResourceStore.toLog("Recorder line input null");
                        if (AudioDevice.this.tLine.isActive()) {
                            AudioDevice.this.tLine.stop();
                            AudioDevice.this.tLine.flush();
                        }
                        if (AudioDevice.this.tLine.isOpen()) {
                            AudioDevice.this.tLine.close();
                        }
                        ResourceStore.toLog("Recorder line stopped");
                        while (AudioDevice.this.recording && AudioDevice.this.output == null) {
                            Recorder.sleep(this.frameTime);
                        }
                        ResourceStore.toLog("Recorder line continue. isOpen=" + AudioDevice.this.tLine.isOpen());
                        continue;
                    }
                    if (!AudioDevice.this.tLine.isOpen()) {
                        AudioDevice.this.tLine.open(AudioDevice.this.format, linebufsize);
                    }
                    if (!AudioDevice.this.tLine.isActive()) {
                        AudioDevice.this.setCaptureLevel(AudioDevice.this.recordlevel);
                        AudioDevice.this.spRecord.reset();
                        AudioDevice.this.tLine.start();
                        ResourceStore.toLog("Recorder line started");
                    }
                    if ((numBytesRead = AudioDevice.this.tLine.read(data, 0, bufsize)) == 0) {
                        AudioDevice.this.reclevel = 0;
                        try {
                            Recorder.sleep(this.frameTime);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    AudioDevice.this.spRecord.resample(data, datar);
                    AudioDevice.this.reclevel = AudioDevice.this.getLevel(datar);
                    if (AudioDevice.this.output == null) {
                        try {
                            Recorder.sleep(this.frameTime);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (AudioDevice.this.mute) {
                        if (++s <= 300) continue;
                        s = 0;
                        AudioDevice.this.output.write(no_input, 0, no_input.length);
                        continue;
                    }
                    int v = AudioDevice.this.spRecord.process(datar);
                    if (AudioDevice.this.vad && v == 0) {
                        if (++s < 300) continue;
                        s = 0;
                    }
                    AudioDevice.this.output.write(datar, 0, datar.length);
                    if (AudioDevice.this.agcRecordMode != 1) continue;
                    int level = AudioDevice.this.spRecord.getSoundCaptureLevel();
                    AudioDevice.this.setCaptureLevel((float)level / 256.0f);
                    AudioDevice.this.spRecord.setSoundCaptureLevel(level);
                }
                catch (LineUnavailableException e) {
                    ResourceStore.error("Recorder line", e);
                    AudioDevice.this.lines.clear();
                    break;
                }
                catch (Exception e) {
                    ResourceStore.error("Recorder line", e);
                    try {
                        Recorder.sleep(this.frameTime);
                    }
                    catch (Exception exception) {}
                }
            }
            AudioDevice.this.spRecord.reset();
            ResourceStore.toLog("Recorder line thread stopping. active=" + AudioDevice.this.tLine.isActive() + " running=" + AudioDevice.this.tLine.isRunning());
            if (AudioDevice.this.tLine.isActive()) {
                AudioDevice.this.tLine.stop();
                AudioDevice.this.tLine.flush();
            }
            if (AudioDevice.this.tLine.isOpen()) {
                AudioDevice.this.tLine.close();
            }
            AudioDevice.this.tLine.removeLineListener(listener);
            ResourceStore.toLog("Recorder line thread stopped. rel=" + AudioDevice.this.released);
        }
    }

    class Player
    extends Thread {
        int frameTime = 10;
        private int result = 512;
        private boolean termstop;

        Player() {
        }

        public void release() {
            this.termstop = true;
        }

        public void setAGC(int mode) {
            AudioDevice.this.spPlayback.setAGC(mode);
        }

        public void setNoiseSuppression(int mode) {
            AudioDevice.this.spPlayback.setNoiseSuppression(mode);
        }

        @Override
        public void run() {
            int linebufsize = (int)((float)(AudioDevice.this.sbufSize * (AudioDevice.this.format.getSampleSizeInBits() / 8)) * (AudioDevice.this.format.getSampleRate() / 1000.0f));
            int bufsize = this.frameTime * 16;
            byte[] data = new byte[bufsize];
            byte[] datar = new byte[bufsize * 6];
            byte[] no_data = new byte[bufsize];
            for (int i = 0; i < no_data.length; ++i) {
                no_data[i] = 0;
            }
            byte[] no_datar = new byte[bufsize * 6];
            for (int i = 0; i < no_datar.length; ++i) {
                no_datar[i] = 0;
            }
            int g = 0;
            ResourceStore.toLog("Player line thread started sbuf=" + AudioDevice.this.sLine.getBufferSize() + " frameRate=" + AudioDevice.this.sLine.getFormat().getFrameRate() + " frameSize=" + AudioDevice.this.sLine.getFormat().getFrameSize() + " sampleRate=" + AudioDevice.this.sLine.getFormat().getSampleRate());
            LineListener listener = new LineListener(){

                @Override
                public void update(LineEvent event) {
                    ResourceStore.toLog("Player Line update:" + event.getType());
                    if (event.getType() == LineEvent.Type.START) {
                        AudioDevice.this.sLineStarted = true;
                    } else if (event.getType() == LineEvent.Type.STOP) {
                        AudioDevice.this.sLineStarted = false;
                    }
                }
            };
            AudioDevice.this.sLine.addLineListener(listener);
            while (AudioDevice.this.playing) {
                if (this.termstop) {
                    this.result = 256;
                    this.termstop = false;
                }
                try {
                    int len;
                    if (AudioDevice.this.input == null) {
                        ResourceStore.toLog("Player line input null");
                        AudioDevice.this.spPlayback.reset();
                        if (AudioDevice.this.sLine.isRunning()) {
                            AudioDevice.this.sLine.stop();
                        }
                        AudioDevice.this.sLine.close();
                        ResourceStore.toLog("Player line stopped");
                        AudioDevice.this.playlevel = 0;
                        while (AudioDevice.this.playing && !this.termstop && AudioDevice.this.input == null) {
                            Player.sleep(this.frameTime);
                        }
                        ResourceStore.toLog("Player line continue");
                        continue;
                    }
                    if (!AudioDevice.this.sLine.isOpen()) {
                        AudioDevice.this.sLine.open(AudioDevice.this.format, linebufsize);
                        AudioDevice.this.sLine.start();
                        Player.sleep(100L);
                        ResourceStore.toLog("Player line started");
                    }
                    int numBytesRead = 0;
                    do {
                        if ((len = AudioDevice.this.input.read(data, numBytesRead, bufsize - numBytesRead)) > 0) continue;
                        if (len != -1) break;
                        numBytesRead = -1;
                        break;
                    } while ((numBytesRead += len) < bufsize);
                    if (numBytesRead == -1) {
                        this.result = 512;
                        AudioDevice.this.input = null;
                        continue;
                    }
                    if (numBytesRead == 0) {
                        System.arraycopy(GAUSSIAN, g, data, 0, bufsize);
                        if ((g += bufsize) >= GAUSSIAN.length) {
                            g = 0;
                        }
                    } else if (numBytesRead < bufsize) {
                        AudioDevice.this.spPlayback.resample(data, datar);
                        AudioDevice.this.sLine.write(datar, 0, numBytesRead * 6);
                        continue;
                    }
                    AudioDevice.this.playlevel = AudioDevice.this.getLevel(data);
                    int vad = AudioDevice.this.spPlayback.process(data);
                    if (vad == 0 && AudioDevice.this.input instanceof PipeInputStream && AudioDevice.this.input.available() > ((PipeInputStream)AudioDevice.this.input).getMinBufferSize()) continue;
                    AudioDevice.this.spPlayback.resample(data, datar);
                    AudioDevice.this.sLine.write(datar, 0, datar.length);
                    AudioDevice.this.spRecord.render(data);
                }
                catch (LineUnavailableException e) {
                    ResourceStore.error("Player line", e);
                    AudioDevice.this.lines.clear();
                    break;
                }
                catch (Exception e) {
                    ResourceStore.error("Player line", e);
                    try {
                        Player.sleep(this.frameTime);
                    }
                    catch (Exception exception) {}
                }
            }
            if (AudioDevice.this.sLine.isRunning()) {
                AudioDevice.this.sLine.drain();
                AudioDevice.this.sLine.stop();
                AudioDevice.this.sLine.close();
            }
            AudioDevice.this.sLine.removeLineListener(listener);
            AudioDevice.this.spPlayback.reset();
            ResourceStore.toLog("Player line thread stopped. result=" + this.result);
        }
    }
}

