/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.phone.video;

import com.lti.civil.CaptureDeviceInfo;
import com.lti.civil.CaptureException;
import com.lti.civil.CaptureObserver;
import com.lti.civil.CaptureStream;
import com.lti.civil.CaptureSystem;
import com.lti.civil.CaptureSystemFactory;
import com.lti.civil.DefaultCaptureSystemFactory;
import com.lti.civil.VideoFormat;
import com.smile.telephony.codec.video.Codec;
import com.smile.telephony.codec.video.H263;
import com.smile.telephony.codec.video.H264;
import com.smile.telephony.video.Frame;
import com.smile.telephony.video.FrameBuffer;
import com.smile.telephony.video.VideoCapability;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import smile.cti.phone.video.DisplayPane;
import smile.cti.phone.video.ShowDesktop;
import smile.util.ResourceStore;

public class CaptureChannel {
    private FrameBuffer outbuf;
    private CaptureDeviceInfo devInfo;
    private CaptureSystem system;
    private CaptureStream stream;
    private boolean isopen = false;
    private boolean iscapturing = false;
    public static boolean showDesktop = false;
    private boolean reading = false;
    private Codec encoder;
    private Thread encoderThread;
    private int maxbitrate = 2048000;
    private String format = "640x480";
    private int startedFormatIndex;
    private Hashtable formats = new Hashtable();
    private long stime = 0L;
    private Vector<Frame> frames = new Vector();
    private int frameRate = 30;
    private int encodedBytes;
    private int encodedFrames;
    private VideoCapability receiverCapability;
    private DisplayPane localPane;
    private Vector formatList;

    public static List<CaptureDeviceInfo> getCaptureDeviceInfoList() throws CaptureException {
        CaptureSystemFactory factory = DefaultCaptureSystemFactory.instance();
        CaptureSystem system = factory.createCaptureSystem();
        system.init();
        List list = system.getCaptureDeviceInfoList();
        system.dispose();
        return list;
    }

    public CaptureChannel(CaptureDeviceInfo info) {
        this.devInfo = info;
    }

    public boolean equals(Object obj) {
        return obj instanceof CaptureChannel && this.devInfo.equals(((CaptureChannel)obj).devInfo);
    }

    public String getName() {
        return this.devInfo.getDescription();
    }

    public String getDeviceID() {
        return this.devInfo.getDeviceID();
    }

    public void setMaxBitrate(int br) {
        this.maxbitrate = br;
    }

    public int getMaxBitrate() {
        return this.maxbitrate;
    }

    public void setFramerate(int fr) {
        this.frameRate = fr;
    }

    public int getRrameRate() {
        return this.frameRate;
    }

    private String formatToString(VideoFormat videoFormat) {
        return videoFormat.getWidth() + "x" + videoFormat.getHeight();
    }

    public Vector getFormatsList() throws CaptureException {
        if (this.formatList != null && !this.formatList.isEmpty()) {
            return this.formatList;
        }
        this.formatList = new Vector();
        boolean wasopen = this.isopen;
        if (!wasopen) {
            this.open();
        }
        for (VideoFormat fmt : this.stream.enumVideoFormats()) {
            String f;
            if (fmt.getHeight() == 0 || fmt.getWidth() == 0 || VideoCapability.getFormatIndex(f = this.formatToString(fmt)) == -1 || this.formatList.contains(f)) continue;
            this.formatList.add(f);
        }
        if (!wasopen) {
            this.close();
        }
        return this.formatList;
    }

    public String getFormat() {
        return this.format;
    }

    public synchronized void setFormat(String fmt, String brate) throws CaptureException {
        boolean fchange;
        ResourceStore.toLog(this + " setFormat: " + fmt + " " + brate + "Kbps.  Old: " + this.format + " " + this.maxbitrate + "Kbps iscapturing=" + this.iscapturing + " isopen=" + this.isopen);
        boolean bchange = brate != null && !brate.equals(String.valueOf(this.maxbitrate));
        boolean bl = fchange = fmt != null && !fmt.equals(this.format);
        if (bchange) {
            this.maxbitrate = Integer.parseInt(brate);
        }
        if (fchange) {
            this.format = fmt;
        }
        if (!this.isopen) {
            return;
        }
        if (fchange) {
            boolean wascapturing = this.iscapturing;
            this.close();
            if (wascapturing) {
                this.startCapture();
            } else {
                this.open();
            }
        } else if (bchange && this.reading) {
            this.changeRate(this.maxbitrate);
        }
        ResourceStore.toLog(this + " setFormat OK");
    }

    public int getHeight() {
        int res;
        try {
            res = this.stream.getVideoFormat().getHeight();
        }
        catch (Exception e) {
            ResourceStore.toLog(e.toString());
            res = 0;
        }
        return res;
    }

    public int getWidth() {
        int res;
        try {
            res = this.stream.getVideoFormat().getWidth();
        }
        catch (Exception e) {
            ResourceStore.toLog(e.toString());
            res = 0;
        }
        return res;
    }

    public float getFPS() {
        float res;
        try {
            res = this.stream.getVideoFormat().getFPS();
        }
        catch (Exception e) {
            ResourceStore.toLog(e.toString());
            res = 0.0f;
        }
        return res;
    }

    public String getPixelFormat() {
        try {
            return this.stream.getVideoFormat().getType();
        }
        catch (Exception e) {
            ResourceStore.toLog(e.toString());
            return null;
        }
    }

    public String toString() {
        return this.devInfo.getDescription();
    }

    public boolean isOpen() {
        return this.isopen;
    }

    public boolean isCapturing() {
        return this.iscapturing;
    }

    public boolean isReading() {
        return this.reading;
    }

    public synchronized void open() throws CaptureException {
        if (this.isopen) {
            return;
        }
        this.system = DefaultCaptureSystemFactory.instance().createCaptureSystem();
        this.system.init();
        this.stream = this.system.openCaptureStream(this.devInfo);
        this.stream.setObserver(new VideoObserver());
        VideoFormat videoFormat = null;
        this.formats.clear();
        for (VideoFormat fmt : this.stream.enumVideoFormats()) {
            String f;
            if (fmt.getHeight() == 0 || fmt.getWidth() == 0 || VideoCapability.getFormatIndex(f = this.formatToString(fmt)) == -1) continue;
            int fps = (int)fmt.getFPS();
            Integer maxfps = (Integer)this.formats.get(f);
            if (maxfps == null || maxfps < fps) {
                this.formats.put(f, fps);
                if (f.equals(this.format)) {
                    videoFormat = fmt;
                }
            }
            if (videoFormat != null) continue;
            videoFormat = fmt;
        }
        if (videoFormat == null) {
            videoFormat = this.stream.getVideoFormat();
        }
        this.stream.setVideoFormat(videoFormat);
        this.format = this.formatToString(videoFormat);
        this.frameRate = (int)videoFormat.getFPS();
        if (this.frameRate == 0) {
            this.frameRate = 30;
        }
        this.isopen = true;
        showDesktop = false;
        this.startedFormatIndex = VideoCapability.getFormatIndex(this.format);
        ResourceStore.toLog(this + " opened. Format=" + this.getFormat() + " index=" + this.startedFormatIndex + " formats=" + this.formats);
    }

    public synchronized void close() throws CaptureException {
        ResourceStore.toLog(this + " close iscapturing=" + this.iscapturing);
        if (this.iscapturing) {
            this.stopEncoder();
            this.iscapturing = false;
            if (this.stream != null) {
                this.stream.stop();
            }
        }
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.stream != null) {
            this.stream.dispose();
        }
        this.stream = null;
        if (this.system != null) {
            this.system.dispose();
        }
        this.system = null;
        this.isopen = false;
        ResourceStore.toLog(this + " closed");
    }

    public void startReceiver(VideoCapability cap, FrameBuffer out) {
        ResourceStore.toLog(this + " startReceiver codec=" + cap.getCodecType() + " iscapturing=" + this.iscapturing);
        this.outbuf = out;
        this.receiverCapability = cap;
        if (this.iscapturing && this.encoderThread == null) {
            this.startEncoder(cap, this.maxbitrate);
        }
    }

    public void stopReceiver() {
        ResourceStore.toLog(this + " stopReceiver encoderThread=" + this.encoderThread);
        this.stopEncoder();
        this.receiverCapability = null;
    }

    private synchronized void startEncoder(VideoCapability cap, int rate) {
        ResourceStore.toLog(this + " startEncoder encoderThread=" + this.encoderThread);
        if (this.encoderThread != null) {
            this.stopEncoder();
        }
        this.encoderThread = new EncoderThread(cap, rate);
        this.encoderThread.start();
    }

    private synchronized void startEncoder(int width, int height, int bitrate, int framerate) {
        ResourceStore.toLog(this + " startEncoder encoderThread=" + this.encoderThread + " size = " + width + "x" + height);
        if (this.encoderThread != null) {
            this.stopEncoder();
        }
        this.encoderThread = new EncoderThread(width, height, bitrate, framerate);
        this.encoderThread.start();
    }

    private synchronized void stopEncoder() {
        this.reading = false;
        if (this.encoderThread != null) {
            try {
                this.encoderThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.encoderThread = null;
        }
        ResourceStore.toLog(this + " stopEncoder encoderThread=" + this.encoderThread);
    }

    private Codec openCodec(VideoCapability cap, int rate) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width == 0 || height == 0) {
            throw new IllegalStateException("Invalid frame size");
        }
        Codec codec = Codec.getCodec(cap, true);
        if (codec instanceof H264) {
            int maxfps;
            int maxbr;
            String captfmt;
            String maxRecvLevel;
            int profile_idc = 66;
            int profile_iop = 128;
            int level_idc = 30;
            String profileLevelId = (String)cap.getParameter("profile-level-id");
            if (profileLevelId != null) {
                try {
                    int plid = Integer.parseInt(profileLevelId, 16);
                    profile_idc = plid >> 16 & 0xFF;
                    profile_iop = plid >> 8 & 0xFF;
                    level_idc = plid & 0xFF;
                }
                catch (NumberFormatException plid) {
                    // empty catch block
                }
            }
            if ((maxRecvLevel = (String)cap.getParameter("max-recv-level")) != null) {
                try {
                    int plid = Integer.parseInt(maxRecvLevel, 16);
                    profile_iop = plid >> 8 & 0xFF;
                    level_idc = plid & 0xFF;
                }
                catch (NumberFormatException plid) {
                    // empty catch block
                }
            }
            if ((profile_iop & 0x10) != 0 && level_idc == 11 || (profile_iop & 0x10) == 0 && level_idc == 9) {
                level_idc = 27;
            }
            String string = captfmt = width > height ? width + "x" + height : height + "x" + width;
            if (VideoCapability.getFormatIndex(captfmt) > H264.getMaxFormatIndex(level_idc)) {
                Vector v = H264.getSupportedFormats(level_idc);
                Enumeration en = v.elements();
                while (en.hasMoreElements()) {
                    Object fmt = (String)en.nextElement();
                    if (width < height) {
                        int n = ((String)fmt).indexOf("x");
                        fmt = ((String)fmt).substring(n + 1) + "x" + ((String)fmt).substring(0, n);
                    }
                    if (!this.setFormat((String)fmt)) continue;
                    width = this.getWidth();
                    captfmt = width > (height = this.getHeight()) ? width + "x" + height : height + "x" + width;
                    break;
                }
            } else if (!captfmt.equals(this.format) && this.setFormat(this.format)) {
                width = this.getWidth();
                height = this.getHeight();
            }
            if ((maxbr = H264.getMaxBr(level_idc)) < rate) {
                rate = maxbr;
            }
            if ((maxfps = H264.getMaxFr(captfmt, level_idc)) != 0) {
                ((H264)codec).setProfile(profile_idc, profile_iop);
                ((H264)codec).setLevel(level_idc);
            }
            ResourceStore.toLog(this + " openCodec. profile_idc=" + profile_idc + " profile_iop=" + profile_iop + " level_idc=" + level_idc + " maxRecvLevel=" + maxRecvLevel + " format=" + width + "x" + height + " rate=" + rate);
        } else if (codec instanceof H263) {
            if ("1".equals((String)cap.getParameter("QCIF")) && !"1".equals((String)cap.getParameter("CIF"))) {
                width = 176;
                height = 144;
            } else {
                width = 352;
                height = 288;
            }
            this.setFormat(width + "x" + height);
        }
        ResourceStore.toLog(this + " openCodec. " + width + "x" + height + " bitrate=" + rate + " frameRate=" + this.frameRate);
        codec.setFrameSize(width, height);
        codec.setParam("pixel_format", this.getPixelFormat());
        codec.setBitRate(rate);
        codec.setFrameRate(this.frameRate);
        codec.setKeyRate(this.frameRate * 2);
        if (!codec.open_codec()) {
            throw new IllegalStateException("Can not open " + cap.getCodec() + " encoder");
        }
        return codec;
    }

    public synchronized boolean setFormat(String newformat) {
        ResourceStore.toLog(this + " setFormat " + newformat + " format=" + this.format + " exists=" + this.formats.containsKey(newformat) + " capt=" + this.iscapturing);
        if (newformat.equals(this.format)) {
            return true;
        }
        if (!this.formats.containsKey(newformat)) {
            return false;
        }
        if (this.iscapturing) {
            String oldformat = this.format;
            try {
                this.stopCapture();
                this.format = newformat;
                this.startCapture();
                ResourceStore.toLog(this + " setFormat oldformat=" + oldformat + " newformat=" + newformat + " fps=" + this.getFPS());
                return true;
            }
            catch (Exception e) {
                this.format = oldformat;
                return false;
            }
        }
        this.format = newformat;
        return true;
    }

    private synchronized boolean changeFormat(String newformat) {
        ResourceStore.toLog(this + " changeFormat newformat=" + newformat);
        if (!this.setFormat(newformat)) {
            return false;
        }
        if (this.reading) {
            Codec enc = Codec.getCodec(this.encoder.getVideoCapability(), true);
            int n = newformat.indexOf("x");
            int width = Integer.parseInt(newformat.substring(0, n));
            int height = Integer.parseInt(newformat.substring(n + 1));
            enc.setFrameSize(width, height);
            enc.setBitRate(this.maxbitrate);
            enc.setParam("pixel_format", this.getPixelFormat());
            this.frameRate = (Integer)this.formats.get(newformat);
            if (this.frameRate == 0) {
                this.frameRate = 30;
            }
            enc.setFrameRate(this.frameRate);
            enc.setKeyRate(this.frameRate * 2);
            if (!enc.open_codec()) {
                return false;
            }
            this.stopCapture(false);
            this.encoder = enc;
            this.startCapture(false);
        }
        return true;
    }

    private synchronized boolean changeFormat(int formatIndex) {
        return this.setFormat(this.getWidth() > this.getHeight() ? VideoCapability.FORMATS[formatIndex] : VideoCapability.FORMATS_P[formatIndex]);
    }

    private synchronized void changeRate(int newrate) {
        ResourceStore.toLog(this + " changeRate newrate=" + newrate + " fps=" + this.getFPS());
        VideoCapability cap = this.encoder.getVideoCapability();
        this.stopEncoder();
        this.startEncoder(cap, Math.min(newrate, cap.getMaxBitrate()));
    }

    public synchronized double adjustRate(double rate) {
        int n;
        if (!this.iscapturing || rate < 8000.0) {
            return -1.0;
        }
        long t = System.currentTimeMillis() - this.stime + 1L;
        if (t < 1000L) {
            return -1.0;
        }
        double realFPS = (double)this.encodedFrames * 1000.0 / (double)t;
        if (realFPS == 0.0) {
            return -1.0;
        }
        int newrate = (int)(rate * (double)this.frameRate / realFPS);
        double realRate = (double)this.encodedBytes * 8000.0 / (double)t;
        int formatIndex = VideoCapability.getFormatIndex(this.format);
        ResourceStore.toLog(this + " adjustRate=" + rate + " newrate=" + newrate + " fps=" + this.getFPS() + " format=" + this.format + " frameRate=" + this.frameRate + " realFPS=" + realFPS + " realRate=" + realRate + " formatIndex=" + formatIndex + " max=" + n + " startIndex=" + this.startedFormatIndex);
        if (showDesktop) {
            this.encoder.setBitRate(newrate);
        } else {
            for (n = this.encoder.getVideoCapability().getMaxFormatIndex(newrate); n >= 0 && n != formatIndex; --n) {
                if (n > formatIndex && n > this.startedFormatIndex || !this.changeFormat(n)) continue;
                return rate;
            }
            this.changeRate(newrate);
        }
        double newRate = (double)this.encoder.getBitRate() * realFPS / (double)this.frameRate;
        ResourceStore.toLog(this + " adjustRate=" + rate + " newrate=" + newRate);
        return newRate;
    }

    public int adjustFormat(int seq, int index) {
        String oldformat = this.getWidth() + "x" + this.getHeight();
        int oldindex = VideoCapability.getFormatIndex(oldformat);
        if (!this.iscapturing || showDesktop) {
            return 31 - oldindex;
        }
        int newindex = 31 - index;
        ResourceStore.toLog(this + " adjustFormat index=" + index + " newindex=" + newindex + " oldformat=" + oldformat);
        if (newindex == oldindex || this.changeFormat(newindex)) {
            return index;
        }
        if (newindex > oldindex) {
            for (int i = newindex - 1; i > oldindex; --i) {
                if (!this.changeFormat(i)) continue;
                return 31 - i;
            }
        } else {
            int i;
            for (i = newindex - 1; i >= 0; --i) {
                if (!this.changeFormat(i)) continue;
                return 31 - i;
            }
            for (i = newindex + 1; i < oldindex; ++i) {
                if (!this.changeFormat(i)) continue;
                return 31 - i;
            }
        }
        return 31 - oldindex;
    }

    public void shrinkCapture() {
        ResourceStore.toLog(this + " shrinkCapture");
        int index = VideoCapability.getFormatIndex(this.getWidth() + "x" + this.getHeight()) - 1;
        for (int i = index - 1; i >= 0 && !this.changeFormat(i); --i) {
        }
    }

    public void decoderRefreshRequest() {
        ResourceStore.toLog(this + " decoderRefreshRequest");
        if (this.reading) {
            this.encoder.setKey();
        }
    }

    public void keyFrameRequest() {
        ResourceStore.toLog(this + " keyFrameRequest");
        if (this.reading) {
            this.encoder.setKey();
        }
    }

    public String getStatistics() {
        if (!this.reading) {
            return "";
        }
        long t = System.currentTimeMillis() - this.stime + 1L;
        int fr = (int)((long)(this.encodedFrames * 1000) / t);
        return "Tx: " + this.getWidth() + "x" + this.getHeight() + " " + (long)(this.encodedBytes * 8) / t + "K/" + fr + "F";
    }

    public void startCapture() {
        this.startCapture(true);
    }

    private synchronized void startCapture(boolean startenc) {
        ResourceStore.toLog(System.currentTimeMillis() + ": Capturing start. isopen=" + this.isopen + " iscapturing=" + this.iscapturing);
        try {
            if (this.iscapturing) {
                return;
            }
            this.open();
            this.stream.start();
            this.frameRate = (int)this.getFPS();
            if (this.frameRate == 0) {
                this.frameRate = 30;
            }
            if (this.receiverCapability != null && this.encoderThread == null && startenc) {
                this.startEncoder(this.receiverCapability, this.maxbitrate);
            }
            ResourceStore.toLog(System.currentTimeMillis() + ": Capturing start " + this.stream.getVideoFormat() + " OK");
            this.iscapturing = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            ResourceStore.toLog(e.toString());
        }
    }

    public synchronized void stopCapture() {
        this.stopCapture(true);
    }

    private synchronized void stopCapture(boolean stopenc) {
        ResourceStore.toLog("Capturing stop. isopen=" + this.isopen + " iscapturing=" + this.iscapturing);
        try {
            if (!this.iscapturing) {
                return;
            }
            if (stopenc) {
                this.stopEncoder();
            }
            this.iscapturing = false;
            if (this.stream != null) {
                this.stream.stop();
            }
            if (this.isopen) {
                this.close();
            }
        }
        catch (CaptureException e) {
            ResourceStore.toLog(e.toString());
        }
        ResourceStore.toLog("Capturing stop OK");
    }

    public void setShowDesktop(boolean on) {
        Dimension ssize = Toolkit.getDefaultToolkit().getScreenSize();
        double width = ssize.getWidth();
        double height = ssize.getHeight();
        this.setShowDesktop(width, height, on);
    }

    public void setShowDesktop(double width, double height, boolean on) {
        ResourceStore.toLog("setShowDesktop on =" + on + " showDesktop=" + showDesktop + " screen = " + width + "x" + height);
        if (on && !showDesktop) {
            double maxsize = 1920.0;
            ShowDesktop.setCurrentScreenForShowDesktop();
            if (this.outbuf != null) {
                this.outbuf.reset();
            } else if (height > maxsize) {
                width = maxsize * width / height;
                height = maxsize;
            }
            this.startEncoder((int)width, (int)height, this.maxbitrate, 10);
        } else if (!on && showDesktop) {
            this.startEncoder(this.receiverCapability, this.maxbitrate);
        }
        showDesktop = on;
    }

    public boolean isShowDesktop() {
        return showDesktop;
    }

    public void setLocalView(DisplayPane pane) {
        this.localPane = pane;
    }

    public void drawLocalImage(byte[] pixels, int w, int h, int bpr) {
        this.localPane.drawImage(pixels, w, h, bpr, true);
    }

    class VideoObserver
    implements CaptureObserver {
        VideoObserver() {
        }

        @Override
        public void onError(CaptureStream stream, CaptureException e) {
            ResourceStore.toLog("onError " + stream);
            e.printStackTrace();
        }

        @Override
        public void onNewImage(byte[] image, int width, int height, int bytesPerRow) {
            if (!CaptureChannel.this.iscapturing) {
                return;
            }
            try {
                long timestamp = System.currentTimeMillis() * 90L & 0xFFFFFFFFL;
                if (CaptureChannel.this.reading) {
                    CaptureChannel.this.frames.add(new Frame(image, timestamp, width, height, bytesPerRow));
                }
                if (CaptureChannel.this.localPane != null && CaptureChannel.this.encoder == null) {
                    CaptureChannel.this.drawLocalImage(image, width, height, bytesPerRow);
                }
            }
            catch (Throwable e) {
                ResourceStore.toLog("VObserver :" + e);
            }
        }

        @Override
        public void onNewImage(CaptureStream stream, byte[] image) {
            if (!CaptureChannel.this.iscapturing) {
                return;
            }
            try {
                byte[] data = new byte[image.length];
                System.arraycopy(image, 0, data, 0, image.length);
                long timestamp = System.currentTimeMillis() * 90L & 0xFFFFFFFFL;
                int width = CaptureChannel.this.getWidth();
                int height = CaptureChannel.this.getHeight();
                int bytesPerRow = width * 3;
                if (CaptureChannel.this.reading) {
                    CaptureChannel.this.frames.add(new Frame(data, timestamp, width, height, bytesPerRow));
                }
                if (CaptureChannel.this.localPane != null && CaptureChannel.this.encoder == null) {
                    CaptureChannel.this.drawLocalImage(image, width, height, bytesPerRow);
                }
            }
            catch (Throwable e) {
                System.out.println("VObserver :" + e);
            }
        }
    }

    class EncoderThread
    extends Thread {
        int fw;
        int fh;
        int fr;

        EncoderThread(VideoCapability cap, int rate) {
            CaptureChannel.this.encodedBytes = 0;
            CaptureChannel.this.encodedFrames = 0;
            CaptureChannel.this.encoder = CaptureChannel.this.openCodec(cap, rate);
            this.fw = CaptureChannel.this.encoder.getWidth();
            this.fh = CaptureChannel.this.encoder.getHeight();
            this.fr = CaptureChannel.this.frameRate;
            ResourceStore.toLog(this + " created");
        }

        EncoderThread(int width, int height, int bitrate, int framerate) {
            CaptureChannel.this.encodedBytes = 0;
            CaptureChannel.this.encodedFrames = 0;
            CaptureChannel.this.encoder = new H264();
            CaptureChannel.this.encoder.setDirection(true);
            CaptureChannel.this.encoder.setFrameSize(width, height);
            CaptureChannel.this.encoder.setParam("pixel_format", "RGB24");
            CaptureChannel.this.encoder.setBitRate(bitrate);
            CaptureChannel.this.encoder.setFrameRate(framerate);
            if (!CaptureChannel.this.encoder.open_codec()) {
                throw new IllegalStateException("Can not open encoder");
            }
            this.fw = CaptureChannel.this.encoder.getWidth();
            this.fh = CaptureChannel.this.encoder.getHeight();
            this.fr = framerate;
            ResourceStore.toLog(this + " created");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CaptureChannel.this.reading = true;
            CaptureChannel.this.outbuf.reset();
            ResourceStore.toLog(this + " start codec thread. frameRate=" + this.fr + " encoder=" + CaptureChannel.this.encoder + " size= " + this.fw + "x" + this.fh);
            CaptureChannel.this.stime = System.currentTimeMillis();
            long nextTick = CaptureChannel.this.stime;
            while (CaptureChannel.this.reading && CaptureChannel.this.encoder != null) {
                try {
                    long s;
                    int ft = 1000 / this.fr;
                    nextTick += (long)ft;
                    Frame currentFrame = null;
                    Vector vector = CaptureChannel.this.frames;
                    synchronized (vector) {
                        if (!CaptureChannel.this.frames.isEmpty()) {
                            currentFrame = (Frame)CaptureChannel.this.frames.lastElement();
                            CaptureChannel.this.frames.clear();
                        }
                    }
                    if (currentFrame != null) {
                        byte[] edata;
                        if (!(showDesktop || currentFrame.width == this.fw && currentFrame.height == this.fh)) {
                            ResourceStore.toLog(this + "Captured frame " + currentFrame.width + "x" + currentFrame.height + " different from " + this.fw + "x" + this.fh);
                            continue;
                        }
                        byte[] img = currentFrame.getData();
                        if (CaptureChannel.this.localPane != null) {
                            try {
                                CaptureChannel.this.drawLocalImage(img, currentFrame.width, currentFrame.height, currentFrame.bytesPerRow);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (showDesktop) {
                            try {
                                img = ShowDesktop.getImageMulti(this.fw, this.fh);
                                edata = CaptureChannel.this.encoder.process(img);
                                if (edata != null) {
                                    long timestamp = System.currentTimeMillis() * 90L & 0xFFFFFFFFL;
                                    Frame frame = new Frame(img, timestamp, this.fw, this.fh, this.fw * 3);
                                    frame.setData(edata);
                                    CaptureChannel.this.outbuf.put(frame);
                                    CaptureChannel.this.encodedBytes += edata.length;
                                    CaptureChannel.this.encodedFrames++;
                                }
                            }
                            catch (Throwable t) {
                                ResourceStore.toLog(this + " - " + t);
                            }
                        } else {
                            if ("NV12".equals(CaptureChannel.this.getPixelFormat())) {
                                int linesize = (int)((double)currentFrame.width * 1.5);
                                int diff = currentFrame.bytesPerRow - linesize;
                                if ((diff = diff / 8 * 8) > 0) {
                                    int w = currentFrame.width + (int)((double)diff / 1.5);
                                    byte[] b = new byte[linesize * currentFrame.height];
                                    int i = 0;
                                    for (int j = 0; i <= img.length - w && j <= b.length - currentFrame.width; i += w, j += currentFrame.width) {
                                        System.arraycopy(img, i, b, j, currentFrame.width);
                                    }
                                    img = b;
                                    currentFrame.bytesPerRow = linesize;
                                }
                            }
                            if ((edata = CaptureChannel.this.encoder.process(img)) != null) {
                                currentFrame.setData(edata);
                                CaptureChannel.this.outbuf.put(currentFrame);
                                CaptureChannel.this.encodedBytes += edata.length;
                                CaptureChannel.this.encodedFrames++;
                            }
                        }
                    }
                    if ((s = nextTick - System.currentTimeMillis()) <= 1L) continue;
                    Thread.sleep(s);
                }
                catch (Exception e) {
                    ResourceStore.toLog("CaptureChannel: " + e);
                    e.printStackTrace();
                    break;
                }
            }
            CaptureChannel.this.stime = 0L;
            CaptureChannel.this.frames.clear();
            CaptureChannel.this.encoder.close_codec();
            CaptureChannel.this.encoder = null;
            ResourceStore.toLog(this + " stop codec thread. encodedFrames=" + CaptureChannel.this.encodedFrames);
        }
    }
}

