/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.phone.video;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import smile.util.ResourceStore;

public class ShowDesktop {
    private static GraphicsDevice currentGraphicsDevice;
    private static Rectangle currentScreen;

    public static void setCurrentScreenForShowDesktop() {
        currentScreen = null;
        Point p = MouseInfo.getPointerInfo().getLocation();
        ResourceStore.toLog("setShowDesktop MouseInfo =" + p);
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] allScreens = env.getScreenDevices();
        for (int i = 0; i < allScreens.length; ++i) {
            GraphicsDevice graphicsDevice = allScreens[i];
            ResourceStore.toLog("setShowDesktop graphicsDevice =" + graphicsDevice);
            GraphicsConfiguration[] graphicsConfigurations = graphicsDevice.getConfigurations();
            int index = 0;
            while (i < graphicsConfigurations.length) {
                GraphicsConfiguration graphicsConfiguration = graphicsConfigurations[index];
                ResourceStore.toLog("setShowDesktop graphicsConfiguration =" + graphicsConfiguration.getBounds());
                ResourceStore.toLog("setShowDesktop contains(p.x, p.y) =" + graphicsConfiguration.getBounds().contains(p.x, p.y));
                if (graphicsConfiguration.getBounds().contains(p.x, p.y)) {
                    currentScreen = graphicsConfiguration.getBounds();
                    currentGraphicsDevice = graphicsDevice;
                }
                ++i;
            }
        }
    }

    public static byte[] getImageMulti(int width, int height) throws Exception {
        Robot robot = null;
        Rectangle screen = null;
        if (currentScreen != null) {
            robot = new Robot(currentGraphicsDevice);
            screen = currentScreen;
        } else {
            robot = new Robot();
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            screen = new Rectangle(0, 0, (int)dim.getWidth(), (int)dim.getHeight());
        }
        BufferedImage desktop = robot.createScreenCapture(screen);
        BufferedImage scaledImage = new BufferedImage(width, height, 4);
        Graphics2D graphics2D = scaledImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawImage(desktop, 0, 0, width, height, null);
        graphics2D.dispose();
        int[] rgb = scaledImage.getRGB(0, 0, width, height, null, 0, width);
        byte[] img = new byte[rgb.length * 3];
        int j = 0;
        for (int i = 0; i < rgb.length; ++i) {
            img[j++] = (byte)rgb[i];
            img[j++] = (byte)(rgb[i] >> 8);
            img[j++] = (byte)(rgb[i] >> 16);
        }
        return img;
    }
}

