/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.phone.video;

import com.lti.civil.CaptureDeviceInfo;
import com.lti.civil.CaptureException;
import com.smile.telephony.codec.video.Codec;
import com.smile.telephony.video.Frame;
import com.smile.telephony.video.FrameBuffer;
import com.smile.telephony.video.VideoCapability;
import com.smile.telephony.video.VideoResource;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import smile.cti.phone.DeviceListener;
import smile.cti.phone.video.CaptureChannel;
import smile.cti.phone.video.DisplayPane;
import smile.util.ResourceStore;

public class VideoDevice {
    private Vector<CaptureChannel> channels;
    private Vector<VideoCapability> capabilities;
    private CaptureChannel channel;
    private DisplayPane window;
    private DisplayPane localView;
    private ImagePainter painter;
    private Hashtable rxlines = new Hashtable();
    private Hashtable txlines = new Hashtable();
    private int mode = -1;
    private DeviceListener deviceListener;

    public Vector findVideoDevices() {
        if (this.channels == null) {
            this.channels = new Vector();
        }
        Vector v = new Vector();
        try {
            List<CaptureDeviceInfo> list = CaptureChannel.getCaptureDeviceInfoList();
            for (int i = this.channels.size() - 1; i >= 0; --i) {
                boolean found = false;
                CaptureChannel c = this.channels.elementAt(i);
                for (CaptureDeviceInfo device : list) {
                    if (!c.getDeviceID().equals(device.getDeviceID())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.channels.remove(i);
            }
            for (CaptureDeviceInfo device : list) {
                boolean found = false;
                Enumeration<CaptureChannel> en = this.channels.elements();
                while (en.hasMoreElements()) {
                    CaptureChannel c = en.nextElement();
                    if (!c.getDeviceID().equals(device.getDeviceID()) || !c.getName().equals(device.getDescription())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.channels.add(new CaptureChannel(device));
            }
        }
        catch (Throwable e) {
            ResourceStore.error("findVideoDevices", e);
        }
        return this.channels;
    }

    public VideoDevice() {
        this.findVideoDevices();
        if (this.channels.isEmpty()) {
            new Timer().scheduleAtFixedRate((TimerTask)new CamFinder(), 30000L, 10000L);
        }
        this.capabilities = new Vector();
        Enumeration en = VideoCapability.getDefaultCapabilities().elements();
        while (en.hasMoreElements()) {
            this.capabilities.add((VideoCapability)en.nextElement());
        }
        if (this.channels.size() > 0) {
            this.channel = this.channels.get(0);
        }
        this.painter = new ImagePainter();
        ResourceStore.toLog("findVideoDevices=" + this.channels);
    }

    public String[] getCaptureDeviceNames() {
        String[] names = new String[this.channels.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.channels.get(i).getName();
        }
        return names;
    }

    public void setDisplayChannel(DisplayPane window) {
        this.window = window;
        ResourceStore.toLog("setDisplayChannel " + window);
    }

    public String setCaptureChannel(String chname, boolean landscape) throws CaptureException {
        int maxindex = VideoCapability.getMaxFormatIndex(this.capabilities);
        int index = 0;
        String format = null;
        List formats = this.getAvailableFormats(chname);
        for (int i = 0; i < formats.size(); ++i) {
            String fmt = (String)formats.get(i);
            int ndx = VideoCapability.getFormatIndex(fmt, landscape);
            if (ndx < index || ndx > maxindex) continue;
            index = ndx;
            format = fmt;
        }
        ResourceStore.toLog("VideoDevice setCaptureChannel chname=" + chname + " format=" + format + " formats=" + formats + " maxindex=" + maxindex + " landscape=" + landscape);
        int bitrate = VideoCapability.getSuggestedBitrate(format);
        this.setCaptureChannel(chname, format, String.valueOf(bitrate));
        return format;
    }

    public void setCaptureChannel(String chname, String format, String bitrate) throws CaptureException {
        ResourceStore.toLog("VideoDevice setCaptureChannel chname=" + chname + " channels=" + this.channels + " format=" + format + " bitrate=" + bitrate);
        CaptureChannel chan = null;
        Enumeration<CaptureChannel> en = this.channels.elements();
        while (en.hasMoreElements()) {
            chan = en.nextElement();
            if (chname != null && !chname.equals(chan.getName())) continue;
        }
        if (chan != null) {
            if (this.channel != chan && this.channel != null && !this.rxlines.isEmpty()) {
                SessionInfo info = (SessionInfo)this.rxlines.elements().nextElement();
                if (this.channel.isReading()) {
                    this.channel.stopReceiver();
                }
                this.channel.close();
                chan.setFormat(format, bitrate);
                chan.startReceiver(info.cap, info.buffer);
            } else {
                chan.setFormat(format, bitrate);
            }
            chan.setLocalView(this.localView);
            this.channel = chan;
        }
    }

    public void openChannel() throws CaptureException {
        if (this.channel != null) {
            this.channel.open();
        }
    }

    public void closeChannel() throws CaptureException {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    public void setVideoMode(int mode) {
        this.mode = mode;
        if (this.channel == null && mode == 0) {
            this.mode = 2;
        }
    }

    public int getVideoMode() {
        return this.mode;
    }

    public Vector getVideoCapabilities() {
        return this.capabilities != null ? this.capabilities : VideoCapability.getDefaultCapabilities();
    }

    public void setVideoCapabilities(Vector caps) {
        if (caps != null) {
            this.capabilities = caps;
        }
    }

    public List getAvailableFormats(String chname) {
        CaptureChannel chan = null;
        Enumeration<CaptureChannel> en = this.channels.elements();
        while (en.hasMoreElements()) {
            chan = en.nextElement();
            if (chname != null && !chname.equals(chan.getName())) continue;
        }
        if (chan != null) {
            try {
                return chan.getFormatsList();
            }
            catch (CaptureException captureException) {
                // empty catch block
            }
        }
        return new Vector();
    }

    public String getCaptureFormat() {
        if (this.channel == null) {
            return null;
        }
        return this.channel.getFormat();
    }

    public void startReceiver(VideoResource line, VideoCapability cap, FrameBuffer output) {
        if (this.mode == 2) {
            return;
        }
        if (this.channel != null) {
            if (this.channel.isReading()) {
                this.channel.stopReceiver();
            }
            this.channel.startReceiver(cap, output);
            if (!(this.channel.isOpen() || this.mode != 0 && this.mode != 1)) {
                this.channel.startCapture();
            }
        }
        ResourceStore.toLog("VideoDevice startReceiver line=" + line + " rxlines=" + this.rxlines + " mode=" + this.mode);
        this.rxlines.put(line, new SessionInfo(cap, output));
    }

    public void stopReceiver(VideoResource line) {
        if (this.channel != null) {
            this.channel.stopReceiver();
        }
        this.rxlines.remove(line);
        if (!this.rxlines.isEmpty()) {
            SessionInfo info = (SessionInfo)this.rxlines.elements().nextElement();
            if (this.channel != null) {
                this.channel.startReceiver(info.cap, info.buffer);
            }
        }
        ResourceStore.toLog("VideoDevice stopReceiver line=" + line + " rxlines=" + this.rxlines);
    }

    public void startTransmitter(VideoResource line, VideoCapability cap, FrameBuffer input) {
        if (this.mode == 1) {
            return;
        }
        this.startDisplay(cap, input);
        ResourceStore.toLog("VideoDevice startTransmitter line=" + line + " txlines=" + this.txlines);
        this.txlines.put(line, new SessionInfo(cap, input));
    }

    public void stopTransmitter(VideoResource line) {
        ResourceStore.toLog("VideoDevice stopTransmitter line=" + line + " txlines=" + this.txlines);
        this.txlines.remove(line);
        if (!this.txlines.isEmpty()) {
            SessionInfo info = (SessionInfo)this.txlines.elements().nextElement();
            this.startDisplay(info.cap, info.buffer);
        } else {
            this.stopDisplay();
        }
        ResourceStore.toLog("VideoDevice stopTransmitter OK. line=" + line + " txlines=" + this.txlines);
    }

    public boolean isShowing() {
        return !this.txlines.isEmpty();
    }

    public double adjustRate(VideoResource line, double rate) {
        try {
            return this.channel.adjustRate(rate);
        }
        catch (Exception e) {
            return -1.0;
        }
    }

    public int adjustFormat(VideoResource line, int seq, int index) {
        try {
            return this.channel.adjustFormat(seq, index);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void keyFrameRequest() {
        if (this.channel != null) {
            this.channel.keyFrameRequest();
        }
    }

    public void decoderRefreshRequest() {
        if (this.channel != null) {
            this.channel.decoderRefreshRequest();
        }
    }

    public void setShowDesktop(boolean on) {
        if (this.channel != null) {
            this.channel.setShowDesktop(on);
        }
    }

    public void setShowDesktop(double width, double height, boolean on) {
        if (this.channel != null) {
            this.channel.setShowDesktop(width, height, on);
        }
    }

    public boolean isShowingDesktop() {
        return this.channel != null ? this.channel.isShowDesktop() : false;
    }

    public void setActiveLine(VideoResource line) {
        SessionInfo info = (SessionInfo)this.rxlines.get(line);
        ResourceStore.toLog(this + " setActiveLine=" + line + " info=" + info + " channel=" + this.channel);
        if (info != null && this.channel != null) {
            if (this.channel.isReading()) {
                this.channel.stopReceiver();
            }
            this.channel.startReceiver(info.cap, info.buffer);
        }
        if ((info = (SessionInfo)this.txlines.get(line)) != null) {
            this.startDisplay(info.cap, info.buffer);
        }
    }

    public void setCapturing(boolean on) {
        ResourceStore.toLog(this + " setCapturing on=" + on + " mode=" + this.mode + " channel=" + this.channel);
        if (this.channel == null) {
            return;
        }
        if (!on) {
            this.channel.stopCapture();
        } else if (this.mode == 0 || this.mode == 1) {
            this.channel.startCapture();
        }
    }

    public boolean isCapturing() {
        return this.channel != null && this.channel.isCapturing();
    }

    public String getCaptureStatistics() {
        if (this.channel == null) {
            return "";
        }
        return this.channel.getStatistics();
    }

    public String getReceivedStatistics() {
        return this.painter.getStatistics();
    }

    private void startDisplay(VideoCapability cap, FrameBuffer input) {
        try {
            this.painter.start(cap, input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void stopDisplay() {
        this.painter.stop();
    }

    public void setOutputFormat(int width, int height, String pixfmt) {
        this.painter.setOutputFormat(width, height, pixfmt);
    }

    public void setLocalPicture(boolean on) {
    }

    public void setLocalView(DisplayPane pane) {
        this.localView = pane;
        if (this.channel != null) {
            this.channel.setLocalView(pane);
        }
    }

    public int getInputImageWidth() {
        return this.painter.getImageWidth();
    }

    public int getInputImageHeight() {
        return this.painter.getImageHeight();
    }

    public void setDeviceListener(DeviceListener listener) {
        this.deviceListener = listener;
    }

    class CamFinder
    extends TimerTask {
        CamFinder() {
        }

        @Override
        public void run() {
            if (VideoDevice.this.channels.isEmpty()) {
                VideoDevice.this.findVideoDevices();
                Enumeration en = VideoDevice.this.channels.elements();
                while (en.hasMoreElements()) {
                    CaptureChannel ch = (CaptureChannel)en.nextElement();
                    try {
                        ch.open();
                        VideoDevice.this.channel = ch;
                        this.cancel();
                        if (VideoDevice.this.rxlines.isEmpty()) break;
                        SessionInfo info = (SessionInfo)VideoDevice.this.rxlines.elements().nextElement();
                        VideoDevice.this.channel.startReceiver(info.cap, info.buffer);
                        break;
                    }
                    catch (Exception e) {
                        ResourceStore.error("CamFinder", e);
                        try {
                            ch.close();
                        }
                        catch (Exception ex) {
                            ResourceStore.error("CamFinder", ex);
                        }
                        this.cancel();
                    }
                }
            }
        }
    }

    class SessionInfo {
        VideoCapability cap;
        FrameBuffer buffer;

        public SessionInfo(VideoCapability cap, FrameBuffer buffer) {
            this.cap = cap;
            this.buffer = buffer;
        }
    }

    class ImagePainter
    implements Runnable {
        private FrameBuffer input;
        private int outwidth;
        private int outheight;
        private String pixfmt;
        private boolean running;
        private long stime = 0L;
        private int dbytes = 0;
        private int dframes = 0;
        private Thread thread;

        ImagePainter() {
        }

        public void start(VideoCapability cap, FrameBuffer input) throws IOException {
            ResourceStore.toLog("ImagePainter start " + cap + " input=" + input);
            if (this.thread != null) {
                this.stop();
            }
            this.input = input;
            Codec decoder = Codec.getCodec(cap, false);
            decoder.setParam("resize_method", "fast_bilinear");
            if (!decoder.open_codec()) {
                throw new IOException("Can not open " + cap.getCodec() + " decoder");
            }
            input.setJitterBuffer(200);
            input.setDecoder(decoder);
            if (this.pixfmt != null) {
                input.setImageFormat(this.outwidth, this.outheight, this.pixfmt, true);
            }
            this.stime = System.currentTimeMillis();
            this.running = true;
            this.thread = new Thread(this);
            this.thread.start();
        }

        public void stop() {
            ResourceStore.toLog("ImagePainter stop");
            this.running = false;
            try {
                this.thread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.thread = null;
        }

        public void setOutputFormat(int width, int height, String pf) {
            ResourceStore.toLog("ImagePainter setOutputFormat " + this.outwidth + "x" + this.outheight);
            this.outwidth = width;
            this.outheight = height;
            this.pixfmt = pf;
            if (this.input != null) {
                this.input.setImageFormat(this.outwidth, this.outheight, this.pixfmt, true);
            }
        }

        @Override
        public void run() {
            ResourceStore.toLog("ImagePainter started. window=" + VideoDevice.this.window);
            while (this.running) {
                try {
                    Frame frame = this.input.get();
                    if (frame == null || VideoDevice.this.window == null) {
                        Thread.sleep(20L);
                        continue;
                    }
                    byte[] pixels = frame.getData();
                    VideoDevice.this.window.drawImage(pixels, frame.width, frame.height, frame.bytesPerRow, false);
                    this.input.setImageFormat(this.outwidth, this.outheight, this.pixfmt, false);
                }
                catch (Exception e) {
                    ResourceStore.toLog("ImagePainter: " + e);
                }
            }
            this.input.setDecoder(null);
            this.input = null;
            ResourceStore.toLog("ImagePainter stopped");
        }

        public String getStatistics() {
            if (!this.running) {
                return "";
            }
            long now = System.currentTimeMillis() + 1L;
            long t = now - this.stime;
            this.stime = now;
            int dbnow = this.input.getDecodedBytes();
            int b = dbnow - this.dbytes;
            this.dbytes = dbnow;
            int dfnow = this.input.getDecodedFrames();
            int f = dfnow - this.dframes;
            this.dframes = dfnow;
            return "Rx: " + this.input.getImageFormat() + " " + (long)(b * 8) / t + "K/" + (long)(f * 1000) / t + "F";
        }

        public int getImageWidth() {
            if (!this.running) {
                return 0;
            }
            return this.input.getImageWidth();
        }

        public int getImageHeight() {
            if (!this.running) {
                return 0;
            }
            return this.input.getImageHeight();
        }
    }
}

