/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import smile.util.Utils;

public class ConnectionInfo
implements Serializable {
    static final long serialVersionUID = 981243723741224023L;
    public static final String PRODUCT_NAME = "h323.application_name";
    public static final String PRODUCT_VERSION = "h323.application_version";
    public static final String SIP_TRANSPORT = "sip.protocol";
    public static final String SIP_SERVER = "h323.gatekeeper";
    public static final String USERNAME = "sip.user";
    public static final String AUTHNAME = "h323.gk_login";
    public static final String PASSWORD = "h323.gk_password";
    public static final String PROXY = "sip.outbound_proxy";
    public static final String EXPIRES = "sip.reg_expires";
    public static final String STUN_SERVER = "stun.server";
    public static final String LOCAL_PORT = "h323.port";
    public static final String NO_RETRY = "sip.noretry";
    public static final String RECONNECT = "sip.reconnect";
    private String id = Utils.createCallId();
    private String name;
    private boolean enabled;
    private boolean defroute;
    private Set prefixes = new HashSet();
    private Map parameters = new HashMap();
    private transient boolean state;

    public ConnectionInfo() {
        this.parameters.put(EXPIRES, 60);
        this.parameters.put(SIP_TRANSPORT, "UDP");
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean getState() {
        return this.state;
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    public boolean isDefault() {
        return this.defroute;
    }

    public void setDefault(boolean state) {
        this.defroute = state;
    }

    public void addPrefix(String prefix) {
        this.prefixes.add(prefix);
    }

    public void removePrefix(String prefix) {
        this.prefixes.remove(prefix);
    }

    public int matchPrefix(String number) {
        int n = 0;
        for (String prefix : this.prefixes) {
            int m;
            if (!number.startsWith(prefix) || (m = prefix.length()) <= n) continue;
            n = m;
        }
        return n;
    }

    public String getUserName() {
        return (String)this.parameters.get(USERNAME);
    }

    public void setUserName(String username) {
        this.parameters.put(USERNAME, username);
    }

    public String getAuthName() {
        return (String)this.parameters.get(AUTHNAME);
    }

    public void setAuthName(String username) {
        this.parameters.put(AUTHNAME, username);
    }

    public String getPassword() {
        return (String)this.parameters.get(PASSWORD);
    }

    public void setPassword(String password) {
        this.parameters.put(PASSWORD, password);
    }

    public String getServer() {
        return (String)this.parameters.get(SIP_SERVER);
    }

    public void setServer(String server) {
        this.parameters.put(SIP_SERVER, server);
    }

    public String getProxy() {
        return (String)this.parameters.get(PROXY);
    }

    public void setProxy(String proxy) {
        this.parameters.put(PROXY, proxy);
    }

    public String getTransport() {
        return (String)this.parameters.get(SIP_TRANSPORT);
    }

    public void setTransport(String transport) {
        this.parameters.put(SIP_TRANSPORT, transport);
    }

    public int getExpires() {
        return (Integer)this.parameters.get(EXPIRES);
    }

    public void setTExpires(int time) {
        this.parameters.put(EXPIRES, time);
    }

    public String getProductName() {
        return (String)this.parameters.get(PRODUCT_NAME);
    }

    public void setProductName(String value) {
        this.parameters.put(PRODUCT_NAME, value);
    }

    public String getProductVersion() {
        return (String)this.parameters.get(PRODUCT_VERSION);
    }

    public void setProductVersion(String value) {
        this.parameters.put(PRODUCT_VERSION, value);
    }

    public Object getParameter(String key) {
        return this.parameters.get(key);
    }

    public void setParameter(String key, Object value) {
        this.parameters.put(key, value);
    }

    public Map getParameters() {
        return this.parameters;
    }

    public void setPong(int value) {
        this.parameters.put("wss.pong", value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConnectionInfo)) {
            return false;
        }
        return this.id.equals(((ConnectionInfo)obj).id);
    }

    public String getKey() {
        return this.getAuthName() + "@" + this.getServer();
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return this.getServer();
    }
}

