/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

public class MimeMessage {
    public static final String CONTENT_TYPE_TEXT = "text";
    public static final String CONTENT_MULTY_TYPE = "multipart";
    public static final String CONTENT_APPLICATION_TYPE = "application";
    public static final String CONTENT_SUBTYPE_XML = "xml";
    public static final String CONTENT_SUBTYPE_PLAIN = "plain";
    public static final String CONTENT_SUBTYPE_MIXED = "mixed";
    public static final String CONTENT_SUBTYPE_RESURSLIST = "resource-lists+xml";
    public static final String CONTENT_SUBTYPE_OCTET_STREAM = "octet-stream";
    private String messageId;
    private List recipients;
    private String domain;
    private String sender;
    private String replyTo;
    private String contentType = "text";
    private String contentSubType = "plain";
    private Properties parameters = new Properties();
    private Object content;
    private int contentLength;
    private String branchId;

    public MimeMessage(String messageId) {
        this.messageId = messageId;
    }

    public String getId() {
        return this.messageId;
    }

    public Object getContent() {
        return this.content;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentSubType() {
        return this.contentSubType;
    }

    public List getRecipients() {
        return this.recipients;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getSender() {
        return this.sender;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public String getParameter(String key) {
        return this.parameters.getProperty(key);
    }

    public void setContent(Object data) {
        this.content = data;
    }

    public void setContentLength(int length) {
        this.contentLength = length;
    }

    public void setContentSubType(String type) {
        this.contentSubType = type;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public void setContentType(String type, String subType) {
        this.contentType = type;
        this.contentSubType = subType;
    }

    public void setRecepients(List recipients) {
        this.recipients = recipients;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setParameter(String key, String value) {
        this.parameters.setProperty(key, value);
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public void parseContentType(String mimeContentType) {
        int n = mimeContentType.indexOf(47);
        if (n != -1) {
            this.contentType = mimeContentType.substring(0, n);
            int m = mimeContentType.indexOf(59, n);
            if (m == -1) {
                this.contentSubType = mimeContentType.substring(n + 1);
            } else {
                this.contentSubType = mimeContentType.substring(n + 1, m);
                String string = mimeContentType.substring(m + 1);
            }
        }
    }

    public String getBoundary() {
        String boundary = (String)this.parameters.get("boundary");
        if (boundary == null) {
            return null;
        }
        if (boundary.startsWith("\"")) {
            boundary = boundary.substring(1);
        }
        if (boundary.endsWith("\"")) {
            boundary = boundary.substring(0, boundary.length() - 1);
        }
        return boundary;
    }

    public byte[] getContentBytes() {
        if (this.content instanceof InputStream) {
            InputStream contentStream = (InputStream)this.content;
            byte[] b = new byte[this.contentLength];
            try {
                int readlength;
                for (int nread = 0; nread < this.contentLength && (readlength = contentStream.read(b, nread, this.contentLength - nread)) > 0; nread += readlength) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.content = b;
        }
        return (byte[])this.content;
    }

    public InputStream getContentStream() {
        if (this.content instanceof InputStream) {
            return (InputStream)this.content;
        }
        if (this.content instanceof byte[]) {
            return new ByteArrayInputStream((byte[])this.content);
        }
        return null;
    }

    public String getBranchId() {
        return this.branchId;
    }

    public void setBranchId(String branchId) {
        this.branchId = branchId;
    }
}

