/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.Hashtable;

public class MimeTypes {
    static Hashtable mimeTypes = new Hashtable();

    public static String get(String str) {
        return (String)mimeTypes.get(str);
    }

    public static String get(File file) {
        int n = file.getName().lastIndexOf(".");
        if (n == -1) {
            return "application/octet-stream";
        }
        String ext = file.getName().substring(n + 1).toLowerCase();
        String type = (String)mimeTypes.get(ext);
        if (type != null) {
            return type;
        }
        return "application/" + ext;
    }

    public static String getFileExtension(String mime) {
        for (String key : mimeTypes.keySet()) {
            if (!mime.equals(mimeTypes.get(key))) continue;
            return key;
        }
        return "";
    }

    static {
        mimeTypes.put("txt", "text/plain");
        mimeTypes.put("htm", "text/html");
        mimeTypes.put("html", "text/html");
        mimeTypes.put("css", "text/css");
        mimeTypes.put("gif", "image/gif");
        mimeTypes.put("png", "image/png");
        mimeTypes.put("jpg", "image/jpeg");
        mimeTypes.put("jpe", "image/jpeg");
        mimeTypes.put("jpeg", "image/jpeg");
        mimeTypes.put("tif", "image/tiff");
        mimeTypes.put("wav", "audio/x-wav");
        mimeTypes.put("js", "text/javascript");
        mimeTypes.put("jar", "application/x-java-archive");
        mimeTypes.put("class", "application/x-java-vm");
        mimeTypes.put("ser", "application/x-java-serialized-object");
        try {
            File file = new File(System.getProperty("user.dir"), "mime-types");
            if (file.exists()) {
                String line;
                LineNumberReader lnr = new LineNumberReader(new FileReader(file));
                while ((line = lnr.readLine()) != null) {
                    int n = line.indexOf(9);
                    if (n == -1) continue;
                    mimeTypes.put(line.substring(0, n), line.substring(n + 1));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

