/*
 * Decompiled with CFR 0.152.
 */
package smile.web.client;

import com.smile.net.TCPSocketChannel;
import com.smile.net.TLSSocketChannel;
import com.smile.security.TrustManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Vector;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import smile.util.ResourceStore;
import smile.web.client.HttpRequest;

public class SocketChannel {
    private TCPSocketChannel channel;
    private Socket socket;
    private InputStream inputStream;
    private OutputStream outputStream;

    public SocketChannel(HttpRequest httpRequest) throws Exception {
        int port;
        boolean ssl = httpRequest.useSSL();
        String host = httpRequest.getHost();
        String proxy = httpRequest.getProxy();
        boolean useProxy = proxy != null && proxy.length() > 0;
        String address = useProxy ? proxy : host;
        int k = address.indexOf(":");
        if (k != -1) {
            port = Integer.parseInt(address.substring(k + 1));
            address = address.substring(0, k);
        } else {
            port = ssl ? 443 : 80;
        }
        ResourceStore.toLog("Creating SocketChannel to " + address + " port=" + port + " proxy=" + useProxy);
        InetAddress iaddress = InetAddress.getByName(address);
        boolean useEngine = useProxy;
        if (useEngine) {
            int timeout = useProxy ? 3000 : 6000;
            this.channel = ssl ? new TLSSocketChannel(new InetSocketAddress(iaddress, port), timeout) : new TCPSocketChannel(new InetSocketAddress(iaddress, port), timeout);
            ResourceStore.toLog("SocketChannel " + iaddress + " created. (" + this.channel.getLocalPort() + ")");
            this.outputStream = this.channel.getOutputStream();
            this.inputStream = this.channel.getInputStream();
            if (useProxy) {
                this.sendHttpConnect(host);
            }
            if (ssl) {
                int n = host.indexOf(58);
                ((TLSSocketChannel)this.channel).createEngine(n != -1 ? host.substring(0, n) : host);
            }
        } else {
            this.socket = ssl ? this.createSSLSocket(iaddress) : new Socket();
            InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getByAddress(iaddress.getAddress()), port);
            this.socket.connect(socketAddress, 5000);
            this.outputStream = this.socket.getOutputStream();
            this.inputStream = this.socket.getInputStream();
        }
    }

    private void sendHttpConnect(String host) throws IOException {
        int status;
        int b;
        String request = "CONNECT " + host + " HTTP/1.1\r\n";
        request = request + "Host: " + host + "\r\n";
        request = request + "Proxy-Connection: Keep-Alive\r\n";
        request = request + "Content-Length: 0\r\n";
        request = request + "\r\n";
        this.outputStream.write(request.getBytes());
        Vector<String> lines = new Vector<String>();
        byte[] buf = new byte[4096];
        boolean crlf = false;
        int i = 0;
        int j = 0;
        while ((b = this.inputStream.read()) != -1) {
            buf[i] = (byte)b;
            if (b == 10 && i > 0 && buf[i - 1] == 13) {
                if (crlf) break;
                crlf = true;
            } else if (crlf) {
                if (b == 32 || b == 9) {
                    buf[i -= 2] = (byte)b;
                    crlf = false;
                } else {
                    String line = new String(buf, j, i - j).trim();
                    lines.add(line);
                    j = i;
                    if (b != 13) {
                        crlf = false;
                    }
                }
            }
            ++i;
        }
        String statusLine = (String)lines.get(0);
        String s = statusLine.substring(statusLine.indexOf(32)).trim();
        int n = s.indexOf(32);
        if (n != -1) {
            s = s.substring(0, n);
        }
        if ((status = Integer.parseInt(s)) != 200) {
            throw new IOException("Proxy response code " + status);
        }
    }

    private Socket createSSLSocket(InetAddress address) throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        TrustManager trustManager = new TrustManager(address);
        javax.net.ssl.TrustManager[] trustManagers = new javax.net.ssl.TrustManager[]{trustManager};
        context.init(null, trustManagers, null);
        SSLSocketFactory factory = context.getSocketFactory();
        return factory.createSocket();
    }

    public boolean isConnected() {
        return this.socket != null && !this.socket.isClosed() || this.channel != null && this.channel.isConnected();
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public int read() throws IOException {
        return this.inputStream.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.inputStream.read(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
    }

    public InetAddress getInetAddress() {
        if (this.socket != null) {
            return this.socket.getInetAddress();
        }
        return this.channel.getInetAddress();
    }

    public int getPort() {
        if (this.socket != null) {
            return this.socket.getPort();
        }
        return this.channel.getPort();
    }

    public InetAddress getLocalAddress() {
        if (this.socket != null) {
            return this.socket.getLocalAddress();
        }
        return this.channel.getLocalAddress();
    }

    public int getLocalPort() {
        if (this.socket != null) {
            return this.socket.getLocalPort();
        }
        return this.channel.getLocalPort();
    }

    public String getProtocol() {
        if (this.socket != null) {
            return this.socket instanceof SSLSocket ? "wss" : "ws";
        }
        return this.channel instanceof TLSSocketChannel ? "wss" : "ws";
    }

    public void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {}
        } else {
            try {
                this.channel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

